/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.transform;

import Jama.Matrix;
import org.openimaj.image.FImage;
import org.openimaj.image.MBFImage;
import org.openimaj.image.processing.transform.ProjectionProcessor;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.point.Point2dImpl;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.math.geometry.shape.Shape;

public class MBFProjectionProcessor
extends ProjectionProcessor<Float[], MBFImage> {
    @Override
    public MBFImage performProjection(int windowMinC, int windowMinR, MBFImage output) {
        FImage[] bands = new FImage[output.numBands()];
        for (int i = 0; i < bands.length; ++i) {
            bands[i] = (FImage)output.getBand(i);
        }
        FImage[][] input = new FImage[this.projectedShapes.size()][];
        for (int i = 0; i < input.length; ++i) {
            MBFImage inputMBF = (MBFImage)this.images.get(i);
            input[i] = new FImage[inputMBF.numBands()];
            for (int j = 0; j < input[i].length; ++j) {
                input[i][j] = (FImage)inputMBF.getBand(j);
            }
        }
        for (int y = 0; y < output.getHeight(); ++y) {
            for (int x = 0; x < output.getWidth(); ++x) {
                Point2dImpl realPoint = new Point2dImpl((float)(windowMinC + x), (float)(windowMinR + y));
                int i = 0;
                for (int k = 0; k < this.projectedRectangles.size(); ++k) {
                    Rectangle r = (Rectangle)this.projectedRectangles.get(k);
                    Shape s = (Shape)this.projectedShapes.get(k);
                    if (r.isInside((Point2d)realPoint) && s.isInside((Point2d)realPoint)) {
                        double[][] transform = ((Matrix)this.transformsInverted.get(i)).getArray();
                        float xt = (float)transform[0][0] * realPoint.x + (float)transform[0][1] * realPoint.y + (float)transform[0][2];
                        float yt = (float)transform[1][0] * realPoint.x + (float)transform[1][1] * realPoint.y + (float)transform[1][2];
                        float zt = (float)transform[2][0] * realPoint.x + (float)transform[2][1] * realPoint.y + (float)transform[2][2];
                        xt /= zt;
                        yt /= zt;
                        for (int j = 0; j < bands.length; ++j) {
                            FImage in = input[i][j];
                            FImage out = bands[j];
                            out.pixels[y][x] = in.getPixelInterpNative(xt, yt, out.pixels[y][x]);
                        }
                    }
                    ++i;
                }
            }
        }
        return output;
    }
}

