/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.resize;

import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.processing.resize.ResizeFilterFunction;
import org.openimaj.image.processing.resize.filters.TriangleFilter;
import org.openimaj.image.processor.SinglebandImageProcessor;
import org.openimaj.math.geometry.shape.Rectangle;

@Reference(type=ReferenceType.Incollection, author={"Schumacher, Dale"}, title="Graphics Gems III", year="1992", pages={"8", "", "16"}, chapter="General Filtered Image Rescaling", url="http://dl.acm.org/citation.cfm?id=130745.130747", editor={"Kirk, David"}, publisher="Academic Press Professional, Inc.", customData={"isbn", "0-12-409671-9", "numpages", "9", "acmid", "130747", "address", "San Diego, CA, USA"})
public class ResizeProcessor
implements SinglebandImageProcessor<Float, FImage> {
    private Mode mode = null;
    private float amount = 0.0f;
    private float newX;
    private float newY;
    private ResizeFilterFunction filterFunction;
    public static final ResizeFilterFunction DEFAULT_FILTER = TriangleFilter.INSTANCE;

    public ResizeProcessor(Mode mode) {
        this.mode = mode;
        this.filterFunction = DEFAULT_FILTER;
    }

    public ResizeProcessor(float amount, ResizeFilterFunction ff) {
        this.mode = Mode.SCALE;
        this.amount = amount;
        this.filterFunction = ff;
    }

    public ResizeProcessor(float newX, float newY, ResizeFilterFunction ff) {
        this.mode = Mode.ASPECT_RATIO;
        this.newX = newX;
        this.newY = newY;
        this.filterFunction = ff;
    }

    public ResizeProcessor(float amount) {
        this(amount, DEFAULT_FILTER);
    }

    public ResizeProcessor(float newX, float newY) {
        this(newX, newY, DEFAULT_FILTER);
    }

    public ResizeProcessor(int maxSize) {
        this.mode = Mode.MAX;
        this.newX = maxSize;
        this.newY = maxSize;
        this.filterFunction = DEFAULT_FILTER;
    }

    public ResizeProcessor(int maxSizeArea, boolean area) {
        this.mode = area ? Mode.MAX_AREA : Mode.MAX;
        this.newX = maxSizeArea;
        this.newY = maxSizeArea;
    }

    public ResizeProcessor(int newX, int newY, boolean aspectRatio) {
        this((float)newX, (float)newY, DEFAULT_FILTER);
        this.mode = aspectRatio ? Mode.ASPECT_RATIO : Mode.FIT;
    }

    public ResizeProcessor(int newX, int newY, boolean aspectRatio, ResizeFilterFunction filterf) {
        this((float)newX, (float)newY, filterf);
        this.mode = aspectRatio ? Mode.ASPECT_RATIO : Mode.FIT;
    }

    public void processImage(FImage image) {
        switch (this.mode) {
            case DOUBLE: {
                ResizeProcessor.internalDoubleSize(image);
                break;
            }
            case HALF: {
                ResizeProcessor.internalHalfSize(image);
                break;
            }
            case FIT: {
                ResizeProcessor.zoomInplace(image, (int)this.newX, (int)this.newY, this.filterFunction);
                break;
            }
            case SCALE: {
                this.newX = (float)image.width * this.amount;
                this.newY = (float)image.height * this.amount;
            }
            case ASPECT_RATIO: {
                ResizeProcessor.resample(image, (int)this.newX, (int)this.newY, true, this.filterFunction);
                break;
            }
            case MAX: {
                ResizeProcessor.resizeMax(image, (int)this.newX, this.filterFunction);
                break;
            }
            case MAX_AREA: {
                ResizeProcessor.resizeMaxArea(image, (int)this.newX, this.filterFunction);
                break;
            }
            case NONE: {
                return;
            }
            default: {
                ResizeProcessor.zoomInplace(image, (int)this.newX, (int)this.newY, this.filterFunction);
            }
        }
    }

    public void setFilterFunction(ResizeFilterFunction filterFunction) {
        this.filterFunction = filterFunction;
    }

    public static FImage resizeMax(FImage image, int maxDim, ResizeFilterFunction filterf) {
        int newWidth;
        int newHeight;
        int width = image.width;
        int height = image.height;
        if (width < maxDim && height < maxDim) {
            return image;
        }
        if (width < height) {
            newHeight = maxDim;
            float resizeRatio = (float)maxDim / (float)height;
            newWidth = (int)((float)width * resizeRatio);
        } else {
            newWidth = maxDim;
            float resizeRatio = (float)maxDim / (float)width;
            newHeight = (int)((float)height * resizeRatio);
        }
        ResizeProcessor.zoomInplace(image, newWidth, newHeight, filterf);
        return image;
    }

    public static FImage resizeMaxArea(FImage image, int maxArea, ResizeFilterFunction filterf) {
        int width = image.width;
        int height = image.height;
        int area = width * height;
        if (area < maxArea) {
            return image;
        }
        float whRatio = width / height;
        int newWidth = (int)Math.sqrt((float)maxArea * whRatio);
        int newHeight = maxArea / newWidth;
        ResizeProcessor.zoomInplace(image, newWidth, newHeight, filterf);
        return image;
    }

    public static FImage resizeMax(FImage image, int maxDim) {
        int newWidth;
        int newHeight;
        int width = image.width;
        int height = image.height;
        if (width < maxDim && height < maxDim) {
            return image;
        }
        if (width < height) {
            newHeight = maxDim;
            float resizeRatio = (float)maxDim / (float)height;
            newWidth = (int)((float)width * resizeRatio);
        } else {
            newWidth = maxDim;
            float resizeRatio = (float)maxDim / (float)width;
            newHeight = (int)((float)height * resizeRatio);
        }
        ResizeProcessor.zoomInplace(image, newWidth, newHeight);
        return image;
    }

    public static FImage resizeMaxArea(FImage image, int maxArea) {
        int width = image.width;
        int height = image.height;
        int area = width * height;
        if (area < maxArea) {
            return image;
        }
        float whRatio = width / height;
        int newWidth = (int)Math.sqrt((float)maxArea * whRatio);
        int newHeight = maxArea / newWidth;
        ResizeProcessor.zoomInplace(image, newWidth, newHeight);
        return image;
    }

    public static <I extends Image<?, I>> I doubleSize(I image) {
        return (I)((SinglebandImageProcessor.Processable)image).process((SinglebandImageProcessor)new ResizeProcessor(Mode.DOUBLE));
    }

    public static FImage doubleSize(FImage image) {
        int nheight = 2 * image.height - 2;
        int nwidth = 2 * image.width - 2;
        FImage newimage = new FImage(nwidth, nheight);
        float[][] im = image.pixels;
        float[][] tmp = newimage.pixels;
        for (int y = 0; y < image.height - 1; ++y) {
            for (int x = 0; x < image.width - 1; ++x) {
                int y2 = 2 * y;
                int x2 = 2 * x;
                tmp[y2][x2] = im[y][x];
                tmp[y2 + 1][x2] = 0.5f * (im[y][x] + im[y + 1][x]);
                tmp[y2][x2 + 1] = 0.5f * (im[y][x] + im[y][x + 1]);
                tmp[y2 + 1][x2 + 1] = 0.25f * (im[y][x] + im[y + 1][x] + im[y][x + 1] + im[y + 1][x + 1]);
            }
        }
        return newimage;
    }

    protected static void internalDoubleSize(FImage image) {
        image.internalAssign(ResizeProcessor.doubleSize(image));
    }

    public static <I extends Image<?, I>> I halfSize(I image) {
        return (I)((SinglebandImageProcessor.Processable)image).process((SinglebandImageProcessor)new ResizeProcessor(Mode.HALF));
    }

    public static FImage halfSize(FImage image) {
        int newheight = image.height / 2;
        int newwidth = image.width / 2;
        FImage newimage = new FImage(newwidth, newheight);
        float[][] im = image.pixels;
        float[][] tmp = newimage.pixels;
        int y = 0;
        int yi = 0;
        while (y < newheight) {
            int x = 0;
            int xi = 0;
            while (x < newwidth) {
                tmp[y][x] = im[yi][xi];
                ++x;
                xi += 2;
            }
            ++y;
            yi += 2;
        }
        return newimage;
    }

    protected static void internalHalfSize(FImage image) {
        image.internalAssign(ResizeProcessor.halfSize(image));
    }

    public static FImage resample(FImage in, int newX, int newY) {
        return ResizeProcessor.resample(in.clone(), newX, newY, false);
    }

    public static FImage resample(FImage in, int newX, int newY, boolean aspect) {
        int nx = newX;
        int ny = newY;
        if (aspect) {
            if (ny > nx) {
                nx = (int)Math.round((double)(in.width * ny) / (double)in.height);
            } else {
                ny = (int)Math.round((double)(in.height * nx) / (double)in.width);
            }
        }
        ResizeProcessor.zoomInplace(in, nx, ny);
        return in;
    }

    public static FImage resample(FImage in, int newX, int newY, boolean aspect, ResizeFilterFunction filterf) {
        int nx = newX;
        int ny = newY;
        if (aspect) {
            if (ny > nx) {
                nx = (int)Math.round((double)(in.width * ny) / (double)in.height);
            } else {
                ny = (int)Math.round((double)(in.height * nx) / (double)in.width);
            }
        }
        ResizeProcessor.zoomInplace(in, nx, ny, filterf);
        return in;
    }

    private static void calc_x_contrib(PixelContributions contribX, double xscale, double fwidth, int dstwidth, int srcwidth, ResizeFilterFunction filterf, int i) {
        block11: {
            block10: {
                if (!(xscale < 1.0)) break block10;
                double width = fwidth / xscale;
                double fscale = 1.0 / xscale;
                if (width <= 0.5) {
                    width = 0.500001;
                    fscale = 1.0;
                }
                contribX.numberOfContributors = 0;
                contribX.contributions = new PixelContribution[(int)(width * 2.0 + 1.0)];
                double center = (double)i / xscale;
                int left = (int)Math.ceil(center - width);
                int right = (int)Math.floor(center + width);
                double density = 0.0;
                for (int j = left; j <= right; ++j) {
                    double weight = center - (double)j;
                    weight = filterf.filter(weight / fscale) / fscale;
                    int n = j < 0 ? -j : (j >= srcwidth ? srcwidth - j + srcwidth - 1 : j);
                    if (n >= srcwidth) {
                        n %= srcwidth;
                    } else if (n < 0) {
                        n = srcwidth - 1;
                    }
                    ++contribX.numberOfContributors;
                    contribX.contributions[k] = new PixelContribution();
                    contribX.contributions[k].pixel = n;
                    contribX.contributions[k].weight = weight;
                    density += weight;
                }
                if (density == 0.0 || density == 1.0) break block11;
                density = 1.0 / density;
                for (int k = 0; k < contribX.numberOfContributors; ++k) {
                    contribX.contributions[k].weight *= density;
                }
                break block11;
            }
            contribX.numberOfContributors = 0;
            contribX.contributions = new PixelContribution[(int)(fwidth * 2.0 + 1.0)];
            double center = (double)i / xscale;
            int left = (int)Math.ceil(center - fwidth);
            int right = (int)Math.floor(center + fwidth);
            for (int j = left; j <= right; ++j) {
                double weight = center - (double)j;
                weight = filterf.filter(weight);
                int n = j < 0 ? -j : (j >= srcwidth ? srcwidth - j + srcwidth - 1 : j);
                if (n >= srcwidth) {
                    n %= srcwidth;
                } else if (n < 0) {
                    n = srcwidth - 1;
                }
                ++contribX.numberOfContributors;
                contribX.contributions[k] = new PixelContribution();
                contribX.contributions[k].pixel = n;
                contribX.contributions[k].weight = weight;
            }
        }
    }

    public static FImage zoomInplace(FImage in, int newX, int newY) {
        ResizeFilterFunction filter = DEFAULT_FILTER;
        return ResizeProcessor.zoomInplace(in, newX, newY, filter);
    }

    public static FImage zoomInplace(FImage in, int newX, int newY, ResizeFilterFunction filterf) {
        FImage dst = new FImage(newX, newY);
        ResizeProcessor.zoom(in, dst, filterf);
        in.internalAssign(dst);
        return in;
    }

    public static FImage zoom(FImage in, FImage dst, ResizeFilterFunction filterf) {
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int srcWidth = in.getWidth();
        int srcHeight = in.getHeight();
        double xscale = (double)dstWidth / (double)srcWidth;
        double yscale = (double)dstHeight / (double)srcHeight;
        float[] work = new float[in.height];
        PixelContributions[] contribY = new PixelContributions[dstHeight];
        for (int i = 0; i < contribY.length; ++i) {
            contribY[i] = new PixelContributions();
        }
        float maxValue = in.max().floatValue();
        double fwidth = filterf.getSupport();
        if (yscale < 1.0) {
            double width = fwidth / yscale;
            double fscale = 1.0 / yscale;
            if (width <= 0.5) {
                width = 0.500001;
                fscale = 1.0;
            }
            for (int i = 0; i < dstHeight; ++i) {
                contribY[i].contributions = new PixelContribution[(int)(width * 2.0 + 1.0)];
                contribY[i].numberOfContributors = 0;
                double center = (double)i / yscale;
                int left = (int)Math.ceil(center - width);
                int right = (int)Math.floor(center + width);
                double density = 0.0;
                for (int j = left; j <= right; ++j) {
                    double weight = center - (double)j;
                    weight = filterf.filter(weight / fscale) / fscale;
                    int n = j < 0 ? -j : (j >= srcHeight ? srcHeight - j + srcHeight - 1 : j);
                    if (n >= srcHeight) {
                        n %= srcHeight;
                    } else if (n < 0) {
                        n = srcHeight - 1;
                    }
                    ++contribY[i].numberOfContributors;
                    contribY[i].contributions[k] = new PixelContribution();
                    contribY[i].contributions[k].pixel = n;
                    contribY[i].contributions[k].weight = weight;
                    density += weight;
                }
                if (density == 0.0 || density == 1.0) continue;
                density = 1.0 / density;
                for (int k = 0; k < contribY[i].numberOfContributors; ++k) {
                    contribY[i].contributions[k].weight *= density;
                }
            }
        } else {
            for (int i = 0; i < dstHeight; ++i) {
                contribY[i].contributions = new PixelContribution[(int)(fwidth * 2.0 + 1.0)];
                contribY[i].numberOfContributors = 0;
                double center = (double)i / yscale;
                double left = Math.ceil(center - fwidth);
                double right = Math.floor(center + fwidth);
                int j = (int)left;
                while ((double)j <= right) {
                    double weight = center - (double)j;
                    weight = filterf.filter(weight);
                    int n = j < 0 ? -j : (j >= srcHeight ? srcHeight - j + srcHeight - 1 : j);
                    if (n >= srcHeight) {
                        n %= srcHeight;
                    } else if (n < 0) {
                        n = srcHeight - 1;
                    }
                    ++contribY[i].numberOfContributors;
                    contribY[i].contributions[k] = new PixelContribution();
                    contribY[i].contributions[k].pixel = n;
                    contribY[i].contributions[k].weight = weight;
                    ++j;
                }
            }
        }
        for (int xx = 0; xx < dstWidth; ++xx) {
            double pel2;
            int j;
            double pel;
            double weight;
            PixelContributions contribX = new PixelContributions();
            ResizeProcessor.calc_x_contrib(contribX, xscale, fwidth, dst.width, in.width, filterf, xx);
            for (int k = 0; k < srcHeight; ++k) {
                weight = 0.0;
                boolean bPelDelta = false;
                pel = in.pixels[k][contribX.contributions[0].pixel];
                for (j = 0; j < contribX.numberOfContributors; ++j) {
                    double d = pel2 = j == 0 ? pel : (double)in.pixels[k][contribX.contributions[j].pixel];
                    if (pel2 != pel) {
                        bPelDelta = true;
                    }
                    weight += pel2 * contribX.contributions[j].weight;
                }
                double d = weight = bPelDelta ? (double)((float)Math.round(weight * 255.0) / 255.0f) : pel;
                if (weight < 0.0) {
                    weight = 0.0;
                } else if (weight > (double)maxValue) {
                    weight = maxValue;
                }
                work[k] = (float)weight;
            }
            for (int i = 0; i < dstHeight; ++i) {
                weight = 0.0;
                boolean bPelDelta = false;
                pel = work[contribY[i].contributions[0].pixel];
                for (j = 0; j < contribY[i].numberOfContributors; ++j) {
                    double d = pel2 = j == 0 ? pel : (double)work[contribY[i].contributions[j].pixel];
                    if (pel2 != pel) {
                        bPelDelta = true;
                    }
                    weight += pel2 * contribY[i].contributions[j].weight;
                }
                double d = weight = bPelDelta ? (double)((float)Math.round(weight * 255.0) / 255.0f) : pel;
                if (weight < 0.0) {
                    weight = 0.0;
                } else if (weight > (double)maxValue) {
                    weight = maxValue;
                }
                dst.pixels[i][xx] = (float)weight;
            }
        }
        return dst;
    }

    public static FImage zoom(FImage in, Rectangle inRect, FImage dst, Rectangle dstRect) {
        return ResizeProcessor.zoom(in, inRect, dst, dstRect, DEFAULT_FILTER);
    }

    public static FImage zoom(FImage in, Rectangle inRect, FImage dst, Rectangle dstRect, ResizeFilterFunction filterf) {
        int n;
        double weight;
        double right;
        double left;
        double center;
        if (!in.getBounds().isInside(inRect) || !dst.getBounds().isInside(dstRect)) {
            throw new IllegalArgumentException("Bad bounds");
        }
        FImage src = in;
        int srcX = (int)inRect.x;
        int srcY = (int)inRect.y;
        int srcWidth = (int)inRect.width;
        int srcHeight = (int)inRect.height;
        int dstX = (int)dstRect.x;
        int dstY = (int)dstRect.y;
        int dstWidth = (int)dstRect.width;
        int dstHeight = (int)dstRect.height;
        float maxValue = in.max().floatValue();
        Float[] work = new Float[srcHeight];
        double xscale = (double)dstWidth / (double)srcWidth;
        PixelContributions[] contribY = new PixelContributions[dstHeight];
        double yscale = (double)dstHeight / (double)srcHeight;
        double fwidth = filterf.getSupport();
        if (yscale < 1.0) {
            double width = fwidth / yscale;
            double fscale = 1.0 / yscale;
            double density = 0.0;
            for (int i = 0; i < dstHeight; ++i) {
                contribY[i] = new PixelContributions();
                contribY[i].numberOfContributors = 0;
                contribY[i].contributions = new PixelContribution[(int)Math.round(width * 2.0 + 1.0)];
                center = (double)i / yscale;
                left = Math.ceil(center - width);
                right = Math.floor(center + width);
                int j = (int)left;
                while ((double)j <= right) {
                    weight = center - (double)j;
                    weight = filterf.filter(weight / fscale) / fscale;
                    n = j < 0 ? -j : (j >= srcHeight ? srcHeight - j + srcHeight - 1 : j);
                    ++contribY[i].numberOfContributors;
                    contribY[i].contributions[k] = new PixelContribution();
                    contribY[i].contributions[k].pixel = n;
                    contribY[i].contributions[k].weight = weight;
                    density += weight;
                    ++j;
                }
                if (density == 0.0 || density == 1.0) continue;
                density = 1.0 / density;
                for (int k = 0; k < contribY[i].numberOfContributors; ++k) {
                    contribY[i].contributions[k].weight *= density;
                }
            }
        } else {
            for (int i = 0; i < dstHeight; ++i) {
                contribY[i] = new PixelContributions();
                contribY[i].numberOfContributors = 0;
                contribY[i].contributions = new PixelContribution[(int)Math.round(fwidth * 2.0 + 1.0)];
                center = (double)i / yscale;
                left = Math.ceil(center - fwidth);
                right = Math.floor(center + fwidth);
                int j = (int)left;
                while ((double)j <= right) {
                    weight = center - (double)j;
                    weight = filterf.filter(weight);
                    n = j < 0 ? -j : (j >= srcHeight ? srcHeight - j + srcHeight - 1 : j);
                    ++contribY[i].numberOfContributors;
                    contribY[i].contributions[k] = new PixelContribution();
                    contribY[i].contributions[k].pixel = n;
                    contribY[i].contributions[k].weight = weight;
                    ++j;
                }
            }
        }
        for (int xx = 0; xx < dstWidth; ++xx) {
            float pel2;
            int j;
            float pel;
            boolean bPelDelta;
            PixelContributions contribX = new PixelContributions();
            ResizeProcessor.calc_x_contrib(contribX, xscale, fwidth, dstWidth, srcWidth, filterf, xx);
            for (int k = 0; k < srcHeight; ++k) {
                weight = 0.0;
                bPelDelta = false;
                pel = src.pixels[k + srcY][contribX.contributions[0].pixel + srcX];
                for (j = 0; j < contribX.numberOfContributors; ++j) {
                    pel2 = src.pixels[k + srcY][contribX.contributions[j].pixel + srcX];
                    if (pel2 != pel) {
                        bPelDelta = true;
                    }
                    weight += (double)pel2 * contribX.contributions[j].weight;
                }
                double d = weight = bPelDelta ? (double)((float)Math.round(weight * 255.0) / 255.0f) : (double)pel;
                if (weight < 0.0) {
                    weight = 0.0;
                } else if (weight > (double)maxValue) {
                    weight = maxValue;
                }
                work[k] = Float.valueOf((float)weight);
            }
            for (int i = 0; i < dstHeight; ++i) {
                weight = 0.0;
                bPelDelta = false;
                pel = work[contribY[i].contributions[0].pixel].floatValue();
                for (j = 0; j < contribY[i].numberOfContributors; ++j) {
                    pel2 = work[contribY[i].contributions[j].pixel].floatValue();
                    if (pel2 != pel) {
                        bPelDelta = true;
                    }
                    weight += (double)pel2 * contribY[i].contributions[j].weight;
                }
                double d = weight = bPelDelta ? (double)((float)Math.round(weight * 255.0) / 255.0f) : (double)pel;
                if (weight < 0.0) {
                    weight = 0.0;
                } else if (weight > (double)maxValue) {
                    weight = maxValue;
                }
                dst.pixels[i + dstY][xx + dstX] = (float)weight;
            }
        }
        return dst;
    }

    static class PixelContributions {
        int numberOfContributors;
        PixelContribution[] contributions;

        PixelContributions() {
        }
    }

    static class PixelContribution {
        int pixel;
        double weight;

        PixelContribution() {
        }
    }

    public static enum Mode {
        DOUBLE,
        HALF,
        SCALE,
        ASPECT_RATIO,
        FIT,
        MAX,
        MAX_AREA,
        NONE;

    }
}

