/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.analysis.algorithm.histogram;

import org.openimaj.image.FImage;
import org.openimaj.image.analyser.ImageAnalyser;
import org.openimaj.math.statistics.distribution.Histogram;

public class HistogramAnalyser
implements ImageAnalyser<FImage> {
    private int nbins;
    private Histogram histogram;

    public HistogramAnalyser(int nbins) {
        this.nbins = nbins;
    }

    public void analyseImage(FImage image) {
        this.histogram = new Histogram(this.nbins);
        for (int r = 0; r < image.height; ++r) {
            for (int c = 0; c < image.width; ++c) {
                int bin = (int)(image.pixels[r][c] * (float)this.nbins);
                if (bin > this.nbins - 1) {
                    bin = this.nbins - 1;
                }
                double[] dArray = (double[])this.histogram.values;
                int n = bin;
                dArray[n] = dArray[n] + 1.0;
            }
        }
    }

    public Histogram getHistogram() {
        return this.histogram;
    }

    public static Histogram getHistogram(FImage image, int nbins) {
        HistogramAnalyser p = new HistogramAnalyser(nbins);
        image.analyseWith((ImageAnalyser)p);
        return p.getHistogram();
    }
}

