/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.analysis.algorithm.histogram;

import org.openimaj.image.FImage;
import org.openimaj.image.analyser.ImageAnalyser;
import org.openimaj.image.analysis.algorithm.histogram.WindowedHistogramExtractor;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.math.statistics.distribution.Histogram;

public class BinnedWindowedExtractor
implements ImageAnalyser<FImage>,
WindowedHistogramExtractor {
    protected int[][] binMap;
    protected int nbins;
    protected float min = 0.0f;
    protected float max = 1.0f;

    public BinnedWindowedExtractor(int nbins) {
        this.nbins = nbins;
    }

    public BinnedWindowedExtractor(int nbins, float min, float max) {
        this.nbins = nbins;
        this.min = min;
        this.max = max;
    }

    @Override
    public int getNumBins() {
        return this.nbins;
    }

    public void setNbins(int nbins) {
        this.nbins = nbins;
    }

    public float getMin() {
        return this.min;
    }

    public void setMin(float min) {
        this.min = min;
    }

    public float getMax() {
        return this.max;
    }

    public void setMax(float max) {
        this.max = max;
    }

    public void analyseImage(FImage image) {
        int height = image.height;
        int width = image.width;
        this.binMap = new int[height][width];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int bin = (int)((image.pixels[y][x] - this.min) / (this.max - this.min) * (float)this.nbins);
                if (bin > this.nbins - 1) {
                    bin = this.nbins - 1;
                }
                this.binMap[y][x] = bin;
            }
        }
    }

    public int[][] getBinMap() {
        return this.binMap;
    }

    @Override
    public Histogram computeHistogram(Rectangle roi) {
        return this.computeHistogram((int)roi.x, (int)roi.y, (int)roi.width, (int)roi.height);
    }

    @Override
    public Histogram computeHistogram(int x, int y, int w, int h) {
        Histogram hist = new Histogram(this.nbins);
        this.computeHistogram(x, y, w, h, hist);
        return hist;
    }

    public Histogram computeHistogram(Rectangle roi, FImage weights) {
        return this.computeHistogram((int)roi.x, (int)roi.y, (int)roi.width, (int)roi.height, weights);
    }

    public Histogram computeHistogram(int x, int y, int w, int h, FImage weights) {
        Histogram hist = new Histogram(this.nbins);
        int starty = Math.max(0, y);
        int startx = Math.max(0, x);
        int stopy = Math.min(this.binMap.length, y + h);
        int stopx = Math.min(this.binMap[0].length, x + w);
        for (int r = starty; r < stopy; ++r) {
            for (int c = startx; c < stopx; ++c) {
                double[] dArray = (double[])hist.values;
                int n = this.binMap[r][c];
                dArray[n] = dArray[n] + (double)weights.pixels[r][c];
            }
        }
        return hist;
    }

    public Histogram computeHistogram(int x, int y, FImage weights, FImage windowWeights) {
        Histogram hist = new Histogram(this.nbins);
        int starty = Math.max(0, y);
        int startx = Math.max(0, x);
        int stopy = Math.min(this.binMap.length, y + windowWeights.height);
        int stopx = Math.min(this.binMap[0].length, x + windowWeights.width);
        int startwr = y < 0 ? -y : y;
        int startwc = x < 0 ? -x : x;
        int r = starty;
        int wr = startwr;
        while (r < stopy) {
            int c = startx;
            int wc = startwc;
            while (c < stopx) {
                double[] dArray = (double[])hist.values;
                int n = this.binMap[r][c];
                dArray[n] = dArray[n] + (double)(weights.pixels[r][c] * windowWeights.pixels[wr][wc]);
                ++c;
                ++wc;
            }
            ++r;
            ++wr;
        }
        return hist;
    }

    @Override
    public void computeHistogram(Rectangle roi, Histogram histogram) {
        this.computeHistogram((int)roi.x, (int)roi.y, (int)roi.width, (int)roi.height, histogram);
    }

    @Override
    public void computeHistogram(int x, int y, int w, int h, Histogram histogram) {
        int starty = Math.max(0, y);
        int startx = Math.max(0, x);
        int stopy = Math.min(this.binMap.length, y + h);
        int stopx = Math.min(this.binMap[0].length, x + w);
        for (int r = starty; r < stopy; ++r) {
            for (int c = startx; c < stopx; ++c) {
                double[] dArray = (double[])histogram.values;
                int n = this.binMap[r][c];
                dArray[n] = dArray[n] + 1.0;
            }
        }
    }
}

