/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.analysis.algorithm;

import org.openimaj.image.FImage;
import org.openimaj.image.analysis.algorithm.SummedSqAreaTable;
import org.openimaj.math.geometry.shape.Rectangle;

public class SummedSqTiltAreaTable
extends SummedSqAreaTable {
    public FImage tiltSum;

    public SummedSqTiltAreaTable() {
    }

    public SummedSqTiltAreaTable(FImage image) {
        this(image, true);
    }

    public SummedSqTiltAreaTable(FImage image, boolean computeTilted) {
        this.computeTable(image, computeTilted);
    }

    private void computeTable(FImage image, boolean computeTilted) {
        if (computeTilted) {
            this.computeRotSqSumIntegralImages(image);
        } else {
            this.computeSqSumIntegralImages(image);
        }
    }

    protected void computeSqSumIntegralImages(FImage img) {
        int width = img.width;
        int height = img.height;
        this.sum = new FImage(width + 1, height + 1);
        this.sqSum = new FImage(width + 1, height + 1);
        float[][] sumData = this.sum.pixels;
        float[][] sqSumData = this.sqSum.pixels;
        for (int y = 1; y <= height; ++y) {
            float rowSum = 0.0f;
            float rowSumSQ = 0.0f;
            float[] row = img.pixels[y - 1];
            for (int x = 1; x <= width; ++x) {
                float pix = row[x - 1];
                sumData[y][x] = sumData[y - 1][x] + (rowSum += pix);
                sqSumData[y][x] = sqSumData[y - 1][x] + (rowSumSQ += pix * pix);
            }
        }
    }

    protected final void computeRotSqSumIntegralImages(FImage image) {
        float gray;
        int x;
        float sqRowSum;
        float rowSum;
        float[] row;
        int width = image.width;
        int height = image.height;
        this.sum = new FImage(width + 1, height + 1);
        this.sqSum = new FImage(width + 1, height + 1);
        this.tiltSum = new FImage(width + 2, height + 2);
        float[] buffer = new float[width];
        if (height > 0) {
            row = image.pixels[0];
            rowSum = 0.0f;
            sqRowSum = 0.0f;
            for (x = 1; x <= width; ++x) {
                gray = row[x - 1];
                this.sum.pixels[1][x] = rowSum += gray;
                float f = gray;
                this.tiltSum.pixels[1][x] = f;
                buffer[x - 1] = f;
                this.sqSum.pixels[1][x] = sqRowSum += gray * gray;
            }
        }
        if (height > 1) {
            row = image.pixels[1];
            rowSum = 0.0f;
            sqRowSum = 0.0f;
            for (x = 1; x < width; ++x) {
                gray = row[x - 1];
                this.sum.pixels[2][x] = this.sum.pixels[1][x] + (rowSum += gray);
                this.sqSum.pixels[2][x] = this.sqSum.pixels[1][x] + (sqRowSum += gray * gray);
                this.tiltSum.pixels[2][x] = this.tiltSum.pixels[1][x - 1] + buffer[x - 1] + this.tiltSum.pixels[1][x + 1] + gray;
                buffer[x - 1] = gray;
            }
            if (width > 0) {
                float gray2 = row[width - 1];
                this.sum.pixels[2][width] = this.sum.pixels[1][width] + (rowSum += gray2);
                this.sqSum.pixels[2][width] = this.sqSum.pixels[1][width] + (sqRowSum += gray2 * gray2);
                this.tiltSum.pixels[2][width] = this.tiltSum.pixels[1][width - 1] + buffer[width - 1] + gray2;
                buffer[width - 1] = gray2;
            }
        }
        for (int y = 3; y <= height; ++y) {
            float[] row2 = image.pixels[y - 1];
            float rowSum2 = 0.0f;
            float sqRowSum2 = 0.0f;
            if (width > 0) {
                float gray3 = row2[0];
                this.sum.pixels[y][1] = this.sum.pixels[y - 1][1] + (rowSum2 += gray3);
                this.sqSum.pixels[y][1] = this.sqSum.pixels[y - 1][1] + (sqRowSum2 += gray3 * gray3);
                this.tiltSum.pixels[y][1] = this.tiltSum.pixels[y - 1][2] + buffer[0] + gray3;
                buffer[0] = gray3;
            }
            for (int x2 = 2; x2 < width; ++x2) {
                float gray4 = row2[x2 - 1];
                this.sum.pixels[y][x2] = this.sum.pixels[y - 1][x2] + (rowSum2 += gray4);
                this.sqSum.pixels[y][x2] = this.sqSum.pixels[y - 1][x2] + (sqRowSum2 += gray4 * gray4);
                this.tiltSum.pixels[y][x2] = this.tiltSum.pixels[y - 1][x2 - 1] + buffer[x2 - 1] + this.tiltSum.pixels[y - 1][x2 + 1] - this.tiltSum.pixels[y - 2][x2] + gray4;
                buffer[x2 - 1] = gray4;
            }
            if (width <= 0) continue;
            float gray5 = row2[width - 1];
            this.sum.pixels[y][width] = this.sum.pixels[y - 1][width] + (rowSum2 += gray5);
            this.sqSum.pixels[y][width] = this.sqSum.pixels[y - 1][width] + (sqRowSum2 += gray5 * gray5);
            this.tiltSum.pixels[y][width] = this.tiltSum.pixels[y - 1][width - 1] + buffer[width - 1] + gray5;
            buffer[width - 1] = gray5;
        }
    }

    public float calculateTiltedSumArea(int x, int y, int width, int height) {
        float p0 = this.tiltSum.pixels[y][x];
        float p1 = this.tiltSum.pixels[y + height][x - height];
        float p2 = this.tiltSum.pixels[y + width][x + width];
        float p3 = this.tiltSum.pixels[y + width + height][x + width - height];
        return p0 - p1 - p2 + p3;
    }

    public float calculateTiltedSumArea(Rectangle r) {
        return this.calculateTiltedSumArea(Math.round(r.x), Math.round(r.y), Math.round(r.width), Math.round(r.height));
    }

    @Override
    public void analyseImage(FImage image) {
        this.computeTable(image, true);
    }
}

