/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.segmentation;

import gnu.trove.map.hash.TObjectFloatHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.MBFImage;
import org.openimaj.image.pixel.ConnectedComponent;
import org.openimaj.image.pixel.Pixel;
import org.openimaj.image.processing.convolution.FGaussianConvolve;
import org.openimaj.image.processor.SinglebandImageProcessor;
import org.openimaj.image.segmentation.Segmenter;
import org.openimaj.math.graph.SimpleWeightedEdge;
import org.openimaj.util.set.DisjointSetForest;

@Reference(type=ReferenceType.Article, author={"Felzenszwalb, Pedro F.", "Huttenlocher, Daniel P."}, title="Efficient Graph-Based Image Segmentation", journal="Int. J. Comput. Vision", volume="59", number="2", month="September", year="2004", pages={"167", "181"}, url="http://dx.doi.org/10.1023/B:VISI.0000022288.19776.77", publisher="Kluwer Academic Publishers")
public class FelzenszwalbHuttenlocherSegmenter<I extends Image<?, I>>
implements Segmenter<I> {
    protected float sigma = 0.5f;
    protected float k = 1.9607843f;
    protected int minSize = 50;

    public FelzenszwalbHuttenlocherSegmenter() {
    }

    public FelzenszwalbHuttenlocherSegmenter(float sigma, float k, int minSize) {
        this.sigma = sigma;
        this.k = k;
        this.minSize = minSize;
    }

    @Override
    public List<ConnectedComponent> segment(I image) {
        if (image instanceof MBFImage) {
            return this.segmentImage((MBFImage)image);
        }
        return this.segmentImage(new MBFImage(new FImage[]{(FImage)image}));
    }

    private float diff(MBFImage image, Pixel p1, Pixel p2) {
        float sum = 0.0f;
        for (FImage band : image.bands) {
            float d = band.pixels[p1.y][p1.x] - band.pixels[p2.y][p2.x];
            sum += d * d;
        }
        return (float)Math.sqrt(sum);
    }

    protected List<ConnectedComponent> segmentImage(MBFImage im) {
        int width = im.getWidth();
        int height = im.getHeight();
        MBFImage smooth = (MBFImage)im.process((SinglebandImageProcessor)new FGaussianConvolve(this.sigma));
        ArrayList<SimpleWeightedEdge<Pixel>> edges = new ArrayList<SimpleWeightedEdge<Pixel>>();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                SimpleWeightedEdge p;
                if (x < width - 1) {
                    p = new SimpleWeightedEdge();
                    p.from = new Pixel(x, y);
                    p.to = new Pixel(x + 1, y);
                    p.weight = this.diff(smooth, (Pixel)p.from, (Pixel)p.to);
                    edges.add((SimpleWeightedEdge<Pixel>)p);
                }
                if (y < height - 1) {
                    p = new SimpleWeightedEdge();
                    p.from = new Pixel(x, y);
                    p.to = new Pixel(x, y + 1);
                    p.weight = this.diff(smooth, (Pixel)p.from, (Pixel)p.to);
                    edges.add((SimpleWeightedEdge<Pixel>)p);
                }
                if (x < width - 1 && y < height - 1) {
                    p = new SimpleWeightedEdge();
                    p.from = new Pixel(x, y);
                    p.to = new Pixel(x + 1, y + 1);
                    p.weight = this.diff(smooth, (Pixel)p.from, (Pixel)p.to);
                    edges.add((SimpleWeightedEdge<Pixel>)p);
                }
                if (x >= width - 1 || y <= 0) continue;
                p = new SimpleWeightedEdge();
                p.from = new Pixel(x, y);
                p.to = new Pixel(x + 1, y - 1);
                p.weight = this.diff(smooth, (Pixel)p.from, (Pixel)p.to);
                edges.add((SimpleWeightedEdge<Pixel>)p);
            }
        }
        DisjointSetForest<Pixel> u = this.segmentGraph(width * height, edges);
        for (int i = 0; i < edges.size(); ++i) {
            Pixel b;
            Pixel a = (Pixel)u.find(((SimpleWeightedEdge)edges.get((int)i)).from);
            if (a == (b = (Pixel)u.find(((SimpleWeightedEdge)edges.get((int)i)).to)) || u.size((Object)a) >= this.minSize && u.size((Object)b) >= this.minSize) continue;
            u.union((Object)a, (Object)b);
        }
        Set subsets = u.getSubsets();
        ArrayList<ConnectedComponent> ccs = new ArrayList<ConnectedComponent>();
        for (Set sp : subsets) {
            ccs.add(new ConnectedComponent(sp));
        }
        return ccs;
    }

    protected DisjointSetForest<Pixel> segmentGraph(int numVertices, List<SimpleWeightedEdge<Pixel>> edges) {
        Collections.sort(edges, SimpleWeightedEdge.ASCENDING_COMPARATOR);
        DisjointSetForest u = new DisjointSetForest(numVertices);
        for (SimpleWeightedEdge<Pixel> edge : edges) {
            u.add(edge.from);
            u.add(edge.to);
        }
        TObjectFloatHashMap threshold = new TObjectFloatHashMap();
        for (Pixel p : u) {
            threshold.put((Object)p, this.k);
        }
        for (int i = 0; i < edges.size(); ++i) {
            Pixel b;
            SimpleWeightedEdge<Pixel> pedge = edges.get(i);
            Pixel a = (Pixel)u.find(pedge.from);
            if (a == (b = (Pixel)u.find(pedge.to)) || !(pedge.weight <= threshold.get((Object)a)) || !(pedge.weight <= threshold.get((Object)b))) continue;
            a = (Pixel)u.union((Object)a, (Object)b);
            threshold.put((Object)a, pedge.weight + this.k / (float)u.size((Object)a));
        }
        return u;
    }
}

