/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.model.pixel;

import java.util.ArrayList;
import org.openimaj.image.FImage;
import org.openimaj.image.MBFImage;
import org.openimaj.image.model.pixel.MBFPixelClassificationModel;
import org.openimaj.math.statistics.distribution.CachingMultivariateGaussian;

public class SingleGaussianPixelModel
extends MBFPixelClassificationModel {
    private static final long serialVersionUID = 1L;
    protected CachingMultivariateGaussian gauss;

    public SingleGaussianPixelModel(int ndims) {
        super(ndims);
    }

    @Override
    protected float classifyPixel(Float[] pix) {
        return (float)this.gauss.estimateProbability(pix);
    }

    public void learnModel(MBFImage ... images) {
        ArrayList<float[]> data = new ArrayList<float[]>();
        for (int i = 0; i < images.length; ++i) {
            for (int y = 0; y < images[i].getHeight(); ++y) {
                for (int x = 0; x < images[i].getWidth(); ++x) {
                    float[] d = new float[this.ndims];
                    for (int j = 0; j < this.ndims; ++j) {
                        d[j] = ((FImage)images[i].getBand((int)j)).pixels[y][x];
                    }
                    data.add(d);
                }
            }
        }
        float[][] arraydata = (float[][])data.toArray((T[])new float[data.size()][this.ndims]);
        this.gauss = CachingMultivariateGaussian.estimate((float[][])arraydata);
    }

    @Override
    public SingleGaussianPixelModel clone() {
        SingleGaussianPixelModel model = new SingleGaussianPixelModel(this.ndims);
        model.gauss = new CachingMultivariateGaussian(this.gauss.getMean().copy(), this.gauss.getCovariance().copy());
        return null;
    }
}

