/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.model.asm.datasets;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;
import org.openimaj.data.dataset.ListBackedDataset;
import org.openimaj.data.dataset.VFSListDataset;
import org.openimaj.image.Image;
import org.openimaj.image.model.asm.datasets.ShapeModelDataset;
import org.openimaj.io.InputStreamObjectReader;
import org.openimaj.io.ObjectReader;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.point.Point2dImpl;
import org.openimaj.math.geometry.shape.PointList;
import org.openimaj.math.geometry.shape.PointListConnections;
import org.openimaj.util.pair.IndependentPair;

public class ShapeModelDatasets {
    private ShapeModelDatasets() {
    }

    public static <IMAGE extends Image<?, IMAGE>> ShapeModelDataset<IMAGE> create(List<IndependentPair<PointList, IMAGE>> data, PointListConnections connections) {
        return new BasicDataset<IMAGE>(data, connections);
    }

    public static <IMAGE extends Image<?, IMAGE>> ShapeModelDataset<IMAGE> loadASFDataset(String path, InputStreamObjectReader<IMAGE> reader) throws IOException {
        return new ASFDataset<IMAGE>(path, reader);
    }

    public static <IMAGE extends Image<?, IMAGE>> ShapeModelDataset<IMAGE> loadPTSDataset(String ptsDirPath, String imgDirPath, String modelFilePath, InputStreamObjectReader<IMAGE> reader) throws IOException {
        return new PTSDataset<IMAGE>(imgDirPath, ptsDirPath, modelFilePath, reader);
    }

    private static class PTSDataset<IMAGE extends Image<?, IMAGE>>
    extends FileBackedDataset<IMAGE> {
        public PTSDataset(String imgsPath, String ptsPath, String modelPath, InputStreamObjectReader<IMAGE> reader) throws IOException {
            super(ptsPath, new PTSReader<IMAGE>(reader, ptsPath, imgsPath), null);
            this.readConnections(modelPath);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void readConnections(String path) throws IOException {
            BufferedReader br = null;
            try {
                String line;
                FileSystemManager fsManager = VFS.getManager();
                br = new BufferedReader(new InputStreamReader(fsManager.resolveFile(path).getContent().getInputStream()));
                this.connections = new PointListConnections();
                while ((line = br.readLine()) != null) {
                    if (!line.trim().startsWith("indices")) continue;
                    String[] data = line.trim().replace("indices(", "").replace(")", "").split(",");
                    boolean isOpen = br.readLine().contains("open_boundary");
                    int prev = Integer.parseInt(data[0]);
                    for (int i = 1; i < data.length; ++i) {
                        int next = Integer.parseInt(data[i]);
                        this.connections.addConnection(prev, next);
                        prev = next;
                    }
                    if (isOpen) continue;
                    this.connections.addConnection(Integer.parseInt(data[data.length - 1]), Integer.parseInt(data[0]));
                }
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }

        private static class PTSReader<IMAGE extends Image<?, IMAGE>>
        implements ObjectReader<IndependentPair<PointList, IMAGE>, FileObject> {
            private static String[] SUPPORTED_IMAGE_EXTS = new String[]{"jpg", "jpeg", "bmp", "png"};
            private InputStreamObjectReader<IMAGE> imReader;
            private FileObject ptsPath;
            private FileObject imgsPath;

            public PTSReader(InputStreamObjectReader<IMAGE> imReader, String ptsPath, String imgsPath) throws IOException {
                this.imReader = imReader;
                FileSystemManager fsManager = VFS.getManager();
                this.ptsPath = fsManager.resolveFile(ptsPath);
                this.imgsPath = fsManager.resolveFile(imgsPath);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IndependentPair<PointList, IMAGE> read(FileObject source) throws IOException {
                PointList pl = new PointList(new Point2d[0]);
                BufferedReader br = null;
                try {
                    String line;
                    br = new BufferedReader(new InputStreamReader(source.getContent().getInputStream()));
                    br.readLine();
                    br.readLine();
                    br.readLine();
                    while ((line = br.readLine()) != null) {
                        if (line.startsWith("}") || line.trim().length() <= 0) continue;
                        String[] parts = line.split("\\s+");
                        float x = Float.parseFloat(parts[0].trim());
                        float y = Float.parseFloat(parts[1].trim());
                        pl.points.add(new Point2dImpl(x, y));
                    }
                }
                finally {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException e) {}
                    }
                }
                Image image = null;
                if (this.imReader != null) {
                    String relPath = this.ptsPath.getName().getRelativeName(source.getName());
                    for (String ext : SUPPORTED_IMAGE_EXTS) {
                        String imRelPath = relPath.substring(0, relPath.lastIndexOf(".") + 1) + ext;
                        FileObject imgPath = this.imgsPath.resolveFile(imRelPath);
                        if (!imgPath.exists()) continue;
                        InputStream imstream = null;
                        try {
                            imstream = imgPath.getContent().getInputStream();
                            image = (Image)this.imReader.read((Object)imstream);
                            break;
                        }
                        catch (IOException e) {
                            break;
                        }
                        finally {
                            if (imstream != null) {
                                try {
                                    imstream.close();
                                }
                                catch (IOException e) {}
                            }
                        }
                    }
                }
                return IndependentPair.pair((Object)pl, image);
            }

            public boolean canRead(FileObject source, String name) {
                return name.endsWith(".pts") && !name.equals("dummy.pts");
            }
        }
    }

    private static class ASFDataset<IMAGE extends Image<?, IMAGE>>
    extends FileBackedDataset<IMAGE> {
        public ASFDataset(String path, InputStreamObjectReader<IMAGE> reader) throws IOException {
            super(path, new ASFReader<IMAGE>(reader), null);
            this.readConnections();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void readConnections() throws IOException {
            this.connections = new PointListConnections();
            FileObject firstASF = this.getFileObject(0);
            BufferedReader br = null;
            try {
                String line;
                br = new BufferedReader(new InputStreamReader(firstASF.getContent().getInputStream()));
                while ((line = br.readLine()) != null) {
                    String[] parts;
                    if (line.startsWith("#") || (parts = line.split("\\s+")).length < 7) continue;
                    int from = Integer.parseInt(parts[4].trim());
                    int to = Integer.parseInt(parts[6].trim());
                    this.connections.addConnection(from, to);
                }
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        private static class ASFReader<IMAGE extends Image<?, IMAGE>>
        implements ObjectReader<IndependentPair<PointList, IMAGE>, FileObject> {
            private static String[] SUPPORTED_IMAGE_EXTS = new String[]{"jpg", "jpeg", "bmp", "png"};
            private InputStreamObjectReader<IMAGE> imReader;

            public ASFReader(InputStreamObjectReader<IMAGE> reader) {
                this.imReader = reader;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IndependentPair<PointList, IMAGE> read(FileObject source) throws IOException {
                PointList pl = new PointList(new Point2d[0]);
                BufferedReader br = null;
                try {
                    String line;
                    br = new BufferedReader(new InputStreamReader(source.getContent().getInputStream()));
                    while ((line = br.readLine()) != null) {
                        String[] parts;
                        if (line.startsWith("#") || (parts = line.split("\\s+")).length < 7) continue;
                        float x = Float.parseFloat(parts[2].trim());
                        float y = Float.parseFloat(parts[3].trim());
                        pl.points.add(new Point2dImpl(x, y));
                    }
                }
                finally {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException e) {}
                    }
                }
                Image image = null;
                if (this.imReader != null) {
                    for (String ext : SUPPORTED_IMAGE_EXTS) {
                        String name = source.getName().getBaseName();
                        name = name.substring(0, name.lastIndexOf(".") + 1) + ext;
                        FileObject file = source.getParent().getChild(name);
                        if (file == null || !file.exists()) continue;
                        InputStream imstream = null;
                        try {
                            imstream = file.getContent().getInputStream();
                            image = (Image)this.imReader.read((Object)imstream);
                            break;
                        }
                        catch (IOException e) {
                        }
                        finally {
                            if (imstream != null) {
                                try {
                                    imstream.close();
                                }
                                catch (IOException e) {}
                            }
                        }
                    }
                }
                if (image != null) {
                    pl.scaleXY((float)image.getWidth(), (float)image.getHeight());
                }
                return new IndependentPair((Object)pl, image);
            }

            public boolean canRead(FileObject source, String name) {
                return name.endsWith(".asf");
            }
        }
    }

    private static abstract class FileBackedDataset<IMAGE extends Image<?, IMAGE>>
    extends VFSListDataset<IndependentPair<PointList, IMAGE>>
    implements ShapeModelDataset<IMAGE> {
        protected PointListConnections connections;

        public FileBackedDataset(String path, ObjectReader<IndependentPair<PointList, IMAGE>, FileObject> reader, PointListConnections conns) throws IOException {
            super(path, reader);
            this.connections = conns;
        }

        @Override
        public PointListConnections getConnections() {
            return this.connections;
        }

        @Override
        public List<PointList> getPointLists() {
            return IndependentPair.getFirst((Iterable)((Object)this));
        }

        @Override
        public List<IMAGE> getImages() {
            return IndependentPair.getSecond((Iterable)((Object)this));
        }
    }

    private static class BasicDataset<IMAGE extends Image<?, IMAGE>>
    extends ListBackedDataset<IndependentPair<PointList, IMAGE>>
    implements ShapeModelDataset<IMAGE> {
        private PointListConnections connections;

        public BasicDataset(List<IndependentPair<PointList, IMAGE>> data, PointListConnections connections) {
            this.data = data;
            this.connections = connections;
        }

        @Override
        public PointListConnections getConnections() {
            return this.connections;
        }

        @Override
        public List<PointList> getPointLists() {
            return IndependentPair.getFirst((Iterable)((Object)this));
        }

        @Override
        public List<IMAGE> getImages() {
            return IndependentPair.getSecond((Iterable)((Object)this));
        }
    }
}

