/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.global;

import org.openimaj.feature.DoubleFV;
import org.openimaj.feature.FeatureVectorProvider;
import org.openimaj.image.FImage;
import org.openimaj.image.analyser.ImageAnalyser;

public class HorizontalIntensityDistribution
implements ImageAnalyser<FImage>,
FeatureVectorProvider<DoubleFV> {
    DoubleFV fv;
    int nbins = 10;

    public HorizontalIntensityDistribution() {
    }

    public HorizontalIntensityDistribution(int nbins) {
        this.nbins = nbins;
    }

    public DoubleFV getFeatureVector() {
        return this.fv;
    }

    public void analyseImage(FImage image) {
        this.fv = new DoubleFV(this.nbins);
        int[] counts = new int[this.nbins];
        float stripWidth = (float)image.width / (float)this.nbins;
        for (int y = 0; y < image.height; ++y) {
            for (int x = 0; x < image.width; ++x) {
                int bin = (int)((float)x / stripWidth);
                double[] dArray = (double[])this.fv.values;
                int n = bin;
                dArray[n] = dArray[n] + (double)image.pixels[y][x];
                int n2 = bin;
                counts[n2] = counts[n2] + 1;
            }
        }
        for (int i = 0; i < this.nbins; ++i) {
            double[] dArray = (double[])this.fv.values;
            int n = i;
            dArray[n] = dArray[n] / (double)counts[i];
        }
    }
}

