/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.connectedcomponent.proc;

import org.openimaj.feature.DoubleFV;
import org.openimaj.feature.FeatureVectorProvider;
import org.openimaj.image.pixel.ConnectedComponent;
import org.openimaj.image.processor.connectedcomponent.ConnectedComponentProcessor;

public class HuMoments
implements ConnectedComponentProcessor,
FeatureVectorProvider<DoubleFV> {
    public double h1;
    public double h2;
    public double h3;
    public double h4;
    public double h5;
    public double h6;
    public double h7;

    public void process(ConnectedComponent cc) {
        double v11 = cc.calculateMomentNormalised(1, 1);
        double v12 = cc.calculateMomentNormalised(1, 2);
        double v21 = cc.calculateMomentNormalised(2, 1);
        double v02 = cc.calculateMomentNormalised(0, 2);
        double v20 = cc.calculateMomentNormalised(2, 0);
        double v03 = cc.calculateMomentNormalised(0, 3);
        double v30 = cc.calculateMomentNormalised(3, 0);
        this.h1 = v20 + v02;
        this.h2 = (v20 - v02) * (v20 - v02) + 4.0 * v11 * v11;
        this.h3 = (v30 - 3.0 * v12) * (v30 - 3.0 * v12) + (3.0 * v21 - v03) * (3.0 * v21 - v03);
        this.h4 = (v30 + v12) * (v30 + v12) + (v21 + v03) * (v21 + v03);
        this.h5 = (v30 - 3.0 * v12) * (v30 + v12) * ((v30 + v12) * (v30 + v12) - 3.0 * (v21 + v03) * (v21 + v03)) + (3.0 * v21 - v03) * (v21 + v03) * (3.0 * (v30 + v12) * (v30 + v12) - (v21 + v03) * (v21 + v03));
        this.h6 = (v20 - v02) * ((v30 + v12) * (v30 + v12) - (v21 + v03) * (v21 + v03)) + 4.0 * v11 * (v30 + v12) * (v21 + v03);
        this.h7 = (3.0 * v21 - v03) * (v30 + v12) * ((v30 + v12) * (v30 + v12) - 3.0 * (v21 + v03) * (v21 + v03)) - (v30 - 3.0 * v12) * (v21 + v03) * (3.0 * (v30 + v12) * (v30 + v12) - (v21 + v03) * (v21 + v03));
    }

    public String toString() {
        return String.format("%2.2f, %2.2f, %2.2f, %2.2f, %2.2f, %2.2f, %2.2f", this.h1, this.h2, this.h3, this.h4, this.h5, this.h6, this.h7);
    }

    public double[] getFeatureVectorArray() {
        return new double[]{this.h1, this.h2, this.h3, this.h4, this.h5, this.h6, this.h7};
    }

    public DoubleFV getFeatureVector() {
        return new DoubleFV(this.getFeatureVectorArray());
    }
}

