/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.connectedcomponent.proc;

import java.util.List;
import org.openimaj.feature.DoubleFV;
import org.openimaj.feature.FeatureVectorProvider;
import org.openimaj.image.pixel.ConnectedComponent;
import org.openimaj.image.pixel.Pixel;
import org.openimaj.image.processor.connectedcomponent.ConnectedComponentProcessor;
import org.openimaj.math.util.Interpolation;

public class BoundaryDistanceDescriptor
implements ConnectedComponentProcessor,
FeatureVectorProvider<DoubleFV> {
    public static final int DESCRIPTOR_LENGTH = 360;
    public double[] descriptor = new double[360];
    protected boolean normaliseScale;
    protected boolean normaliseAngle;

    public BoundaryDistanceDescriptor() {
        this(true, true);
    }

    public BoundaryDistanceDescriptor(boolean normaliseDistance, boolean normaliseAngle) {
        this.normaliseScale = normaliseDistance;
        this.normaliseAngle = normaliseAngle;
    }

    public void process(ConnectedComponent cc) {
        int i;
        cc = new ConnectedComponent(cc.calculateConvexHull());
        List bound = cc.getInnerBoundary(ConnectedComponent.ConnectMode.CONNECT_8);
        double[] centroid = cc.calculateCentroid();
        double direction = cc.calculateDirection();
        float[] distances = new float[bound.size()];
        float[] angle = new float[bound.size()];
        int count = 0;
        for (i = 0; i < bound.size(); ++i) {
            float dist;
            Pixel p = (Pixel)bound.get(i);
            double o = (double)p.y - centroid[1];
            double a = (double)p.x - centroid[0];
            distances[i] = dist = (float)Math.sqrt(a * a + o * o);
            angle[i] = this.normaliseAngle ? (float)(direction - Math.atan2(o, a)) : (float)Math.atan2(o, a);
            int n = i;
            float f = (float)((double)angle[n] % (Math.PI * 2));
            angle[n] = f;
            angle[i] = (float)(f >= 0.0f ? (double)angle[i] : (double)angle[i] + Math.PI * 2);
            angle[i] = (float)(360.0 * (double)angle[i] / (Math.PI * 2));
        }
        for (i = 0; i < 360; ++i) {
            int index1 = -1;
            int index2 = -1;
            for (int j = 0; j < angle.length; ++j) {
                int n = j + 1 == angle.length ? 0 : j + 1;
                float aj = angle[j];
                float an = angle[n];
                if (an > 350.0f && aj < 10.0f) {
                    if (i < 10) {
                        an -= 360.0f;
                    } else {
                        aj += 360.0f;
                    }
                }
                if (aj > 350.0f && an < 10.0f) {
                    if (i < 10) {
                        aj -= 360.0f;
                    } else {
                        an += 360.0f;
                    }
                }
                if (aj == (float)i) {
                    index1 = j;
                    index2 = j;
                    break;
                }
                if (aj < an) {
                    if (!((float)i <= an) || !((float)i > aj)) continue;
                    index1 = j;
                    index2 = n;
                    break;
                }
                if (!((float)i <= aj) || !((float)i > an)) continue;
                index1 = j;
                index2 = n;
                break;
            }
            this.descriptor[i] = Interpolation.lerp((float)i, (float)angle[index1], (float)distances[index1], (float)angle[index2], (float)distances[index2]);
            count = (int)((double)count + this.descriptor[i]);
        }
        if (this.normaliseScale) {
            i = 0;
            while (i < 360) {
                int n = i++;
                this.descriptor[n] = this.descriptor[n] / (double)count;
            }
        }
    }

    public double[] getFeatureVectorArray() {
        return this.descriptor;
    }

    public DoubleFV getFeatureVector() {
        return new DoubleFV(this.getFeatureVectorArray());
    }
}

