/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.connectedcomponent;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.openimaj.image.FImage;
import org.openimaj.image.analyser.ImageAnalyser;
import org.openimaj.image.pixel.ConnectedComponent;
import org.openimaj.image.pixel.Pixel;

public class GreyscaleConnectedComponentLabeler
implements ImageAnalyser<FImage> {
    List<ConnectedComponent> components;

    public List<ConnectedComponent> findComponents(FImage image) {
        this.analyseImage(image);
        return this.components;
    }

    protected ConnectedComponent floodFill(FImage image, Pixel start, int[][] output, int color) {
        ConnectedComponent cc = new ConnectedComponent();
        LinkedHashSet<Pixel> queue = new LinkedHashSet<Pixel>();
        float targetColour = image.pixels[start.y][start.x];
        queue.add(start);
        while (queue.size() > 0) {
            Pixel n = (Pixel)queue.iterator().next();
            queue.remove(n);
            if (image.pixels[n.y][n.x] != targetColour) continue;
            int e = n.x;
            for (int w = n.x; w > 0 && image.pixels[n.y][w - 1] == targetColour; --w) {
            }
            while (e < image.width - 1 && image.pixels[n.y][e + 1] == targetColour) {
                ++e;
            }
            for (int i = w; i <= e; ++i) {
                output[n.y][i] = color;
                cc.addPixel(i, n.y);
                int north = n.y - 1;
                int south = n.y + 1;
                if (north >= 0 && image.pixels[north][i] == targetColour && output[north][i] != color) {
                    queue.add(new Pixel(i, north));
                }
                if (south >= image.height || image.pixels[south][i] != targetColour || output[south][i] == color) continue;
                queue.add(new Pixel(i, south));
            }
        }
        return cc;
    }

    public void analyseImage(FImage image) {
        this.components = new ArrayList<ConnectedComponent>();
        int[][] labels = new int[image.height][image.width];
        int nextColor = 1;
        for (int y = 0; y < image.height; ++y) {
            for (int x = 0; x < image.width; ++x) {
                if (labels[y][x] != 0) continue;
                this.components.add(this.floodFill(image, new Pixel(x, y), labels, nextColor));
                ++nextColor;
            }
        }
    }

    public List<ConnectedComponent> getComponents() {
        return this.components;
    }
}

