/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.face.recognition;

import org.openimaj.data.dataset.GroupedDataset;
import org.openimaj.data.dataset.ListDataset;
import org.openimaj.feature.DoubleFVComparator;
import org.openimaj.feature.FVProviderExtractor;
import org.openimaj.feature.FeatureExtractor;
import org.openimaj.image.processing.face.alignment.FaceAligner;
import org.openimaj.image.processing.face.detection.DetectedFace;
import org.openimaj.image.processing.face.feature.FisherFaceFeature;
import org.openimaj.image.processing.face.recognition.AnnotatorFaceRecogniser;
import org.openimaj.image.processing.face.recognition.FaceRecogniser;
import org.openimaj.image.processing.face.recognition.LazyFaceRecogniser;
import org.openimaj.ml.annotation.IncrementalAnnotator;
import org.openimaj.ml.annotation.basic.KNNAnnotator;
import org.openimaj.util.comparator.DistanceComparator;

public class FisherFaceRecogniser<FACE extends DetectedFace, PERSON>
extends LazyFaceRecogniser<FACE, PERSON, FisherFaceFeature.Extractor<FACE>> {
    protected FisherFaceRecogniser() {
    }

    public FisherFaceRecogniser(FisherFaceFeature.Extractor<FACE> extractor, FaceRecogniser<FACE, PERSON> internalRecogniser) {
        super(extractor, internalRecogniser);
    }

    public FisherFaceRecogniser(FisherFaceFeature.Extractor<FACE> extractor, IncrementalAnnotator<FACE, PERSON> annotator) {
        this(extractor, (FaceRecogniser<FACE, PERSON>)AnnotatorFaceRecogniser.create(annotator));
    }

    public static <FACE extends DetectedFace, PERSON> FisherFaceRecogniser<FACE, PERSON> create(int numComponents, FaceAligner<FACE> aligner, int k, DoubleFVComparator compar) {
        FisherFaceFeature.Extractor<FACE> extractor = new FisherFaceFeature.Extractor<FACE>(numComponents, aligner);
        FVProviderExtractor extractor2 = FVProviderExtractor.create(extractor);
        KNNAnnotator knn = KNNAnnotator.create((FeatureExtractor)extractor2, (DistanceComparator)compar, (int)k);
        return new FisherFaceRecogniser<FACE, PERSON>(extractor, knn);
    }

    public static <FACE extends DetectedFace, PERSON> FisherFaceRecogniser<FACE, PERSON> create(int numComponents, FaceAligner<FACE> aligner, int k, DoubleFVComparator compar, float threshold) {
        FisherFaceFeature.Extractor<FACE> extractor = new FisherFaceFeature.Extractor<FACE>(numComponents, aligner);
        FVProviderExtractor extractor2 = FVProviderExtractor.create(extractor);
        KNNAnnotator knn = KNNAnnotator.create((FeatureExtractor)extractor2, (DistanceComparator)compar, (int)k, (float)threshold);
        return new FisherFaceRecogniser<FACE, PERSON>(extractor, knn);
    }

    @Override
    protected void beforeBatchTrain(GroupedDataset<PERSON, ListDataset<FACE>, FACE> dataset) {
        ((FisherFaceFeature.Extractor)this.extractor).train(dataset);
    }

    public String toString() {
        return String.format("FisherFaceRecogniser[extractor=%s; recogniser=%s]", new Object[]{this.extractor, this.internalRecogniser});
    }
}

