/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.face.feature;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.openimaj.feature.local.list.LocalFeatureList;
import org.openimaj.feature.local.list.MemoryLocalFeatureList;
import org.openimaj.image.feature.local.engine.DoGSIFTEngine;
import org.openimaj.image.feature.local.keypoints.Keypoint;
import org.openimaj.image.processing.face.detection.DetectedFace;
import org.openimaj.image.processing.face.feature.FacialFeature;
import org.openimaj.image.processing.face.feature.FacialFeatureExtractor;
import org.openimaj.math.geometry.shape.Rectangle;

public class DoGSIFTFeature
implements FacialFeature {
    protected LocalFeatureList<Keypoint> keys;
    protected Rectangle bounds;

    protected void initialise(DetectedFace face) {
        DoGSIFTEngine engine = new DoGSIFTEngine();
        this.keys = engine.findFeatures(face.getFacePatch());
        this.bounds = face.getFacePatch().getBounds();
    }

    public void readBinary(DataInput in) throws IOException {
        this.keys = MemoryLocalFeatureList.readNoHeader((DataInput)in, Keypoint.class);
    }

    public byte[] binaryHeader() {
        return this.getClass().getName().getBytes();
    }

    public void writeBinary(DataOutput out) throws IOException {
        this.keys.writeBinary(out);
    }

    public LocalFeatureList<Keypoint> getKeys() {
        return this.keys;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public static class Extractor
    implements FacialFeatureExtractor<DoGSIFTFeature, DetectedFace> {
        public void readBinary(DataInput in) throws IOException {
        }

        public byte[] binaryHeader() {
            return this.getClass().getName().getBytes();
        }

        public void writeBinary(DataOutput out) throws IOException {
        }

        public DoGSIFTFeature extractFeature(DetectedFace face) {
            DoGSIFTFeature feature = new DoGSIFTFeature();
            feature.initialise(face);
            return feature;
        }
    }
}

