/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.face.detection.keypoints;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.openimaj.image.FImage;
import org.openimaj.image.processing.face.detection.DetectedFace;
import org.openimaj.image.processing.face.detection.keypoints.FacialKeypoint;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.point.Point2dImpl;
import org.openimaj.math.geometry.shape.Rectangle;

public class KEDetectedFace
extends DetectedFace {
    protected FacialKeypoint[] keypoints;

    public KEDetectedFace() {
    }

    public KEDetectedFace(Rectangle bounds, FImage patch, FacialKeypoint[] keypoints, float confidence) {
        super(bounds, patch, confidence);
        this.keypoints = keypoints;
    }

    public FacialKeypoint getKeypoint(FacialKeypoint.FacialKeypointType type) {
        return FacialKeypoint.getKeypoint(this.keypoints, type);
    }

    public FacialKeypoint getKeypointInterpolated(FacialKeypoint.FacialKeypointType type) {
        FacialKeypoint kpt = this.getKeypoint(type);
        if (kpt == null) {
            switch (type) {
                case EYE_LEFT_CENTER: {
                    return this.createInterpolated(type, this.getKeypoint(FacialKeypoint.FacialKeypointType.EYE_LEFT_LEFT), this.getKeypoint(FacialKeypoint.FacialKeypointType.EYE_LEFT_RIGHT));
                }
                case EYE_RIGHT_CENTER: {
                    return this.createInterpolated(type, this.getKeypoint(FacialKeypoint.FacialKeypointType.EYE_RIGHT_LEFT), this.getKeypoint(FacialKeypoint.FacialKeypointType.EYE_RIGHT_RIGHT));
                }
                case MOUTH_CENTER: {
                    return this.createInterpolated(type, this.getKeypoint(FacialKeypoint.FacialKeypointType.MOUTH_LEFT), this.getKeypoint(FacialKeypoint.FacialKeypointType.MOUTH_RIGHT));
                }
            }
        }
        return null;
    }

    private FacialKeypoint createInterpolated(FacialKeypoint.FacialKeypointType type, FacialKeypoint left, FacialKeypoint right) {
        if (left == null || right == null) {
            return null;
        }
        float x = right.position.x - left.position.x;
        float y = right.position.y - left.position.y;
        return new FacialKeypoint(type, (Point2d)new Point2dImpl(x, y));
    }

    public FacialKeypoint[] getKeypoints() {
        return this.keypoints;
    }

    @Override
    public void writeBinary(DataOutput out) throws IOException {
        super.writeBinary(out);
        out.writeInt(this.keypoints.length);
        for (FacialKeypoint k : this.keypoints) {
            k.writeBinary(out);
        }
    }

    @Override
    public byte[] binaryHeader() {
        return "KEDF".getBytes();
    }

    @Override
    public void readBinary(DataInput in) throws IOException {
        super.readBinary(in);
        int sz = in.readInt();
        this.keypoints = new FacialKeypoint[sz];
        for (int i = 0; i < sz; ++i) {
            this.keypoints[i] = new FacialKeypoint();
            this.keypoints[i].readBinary(in);
        }
    }
}

