/*
 * Decompiled with CFR 0.152.
 */
package ch.akuhn.matrix;

import ch.akuhn.matrix.Vector;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class SparseVector
extends Vector {
    int[] keys;
    int size;
    int used;
    double[] values;

    protected SparseVector(double[] values) {
        this(values.length);
        for (int n = 0; n < values.length; ++n) {
            if (values[n] == 0.0) continue;
            this.put(n, values[n]);
        }
    }

    protected SparseVector(int size) {
        this(size, 10);
    }

    public SparseVector(int size, int capacity) {
        assert (size >= 0);
        assert (capacity >= 0);
        this.size = size;
        this.keys = new int[capacity];
        this.values = new double[capacity];
    }

    @Override
    public double add(int key, double value) {
        if (key < 0 || key >= this.size) {
            throw new IndexOutOfBoundsException(Integer.toString(key));
        }
        int spot = Arrays.binarySearch(this.keys, 0, this.used, key);
        if (spot >= 0) {
            int n = spot;
            double d = this.values[n] + value;
            this.values[n] = d;
            return d;
        }
        return this.update(-1 - spot, key, value);
    }

    @Override
    public Iterable<Vector.Entry> entries() {
        return new Iterable<Vector.Entry>(){

            @Override
            public Iterator<Vector.Entry> iterator() {
                return new Iterator<Vector.Entry>(){
                    private int spot = 0;

                    @Override
                    public boolean hasNext() {
                        return this.spot < SparseVector.this.used;
                    }

                    @Override
                    public Vector.Entry next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return new Vector.Entry(SparseVector.this, SparseVector.this.keys[this.spot], SparseVector.this.values[this.spot++]);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public boolean equals(Object obj) {
        return obj instanceof SparseVector && this.equals((SparseVector)obj);
    }

    public boolean equals(SparseVector v) {
        return this.size == v.size && this.used == v.used && Arrays.equals(this.keys, v.keys) && Arrays.equals(this.values, this.values);
    }

    @Override
    public double get(int key) {
        if (key < 0 || key >= this.size) {
            throw new IndexOutOfBoundsException(Integer.toString(key));
        }
        int spot = Arrays.binarySearch(this.keys, 0, this.used, key);
        return spot < 0 ? 0.0 : this.values[spot];
    }

    public int hashCode() {
        return this.size ^ Arrays.hashCode(this.keys) ^ Arrays.hashCode(this.values);
    }

    public boolean isUsed(int key) {
        return 0 <= Arrays.binarySearch(this.keys, 0, this.used, key);
    }

    @Override
    public double put(int key, double value) {
        if (key < 0 || key >= this.size) {
            throw new IndexOutOfBoundsException(Integer.toString(key));
        }
        int spot = Arrays.binarySearch(this.keys, 0, this.used, key);
        if (spot >= 0) {
            this.values[spot] = (float)value;
            return this.values[spot];
        }
        return this.update(-1 - spot, key, value);
    }

    public void resizeTo(int newSize) {
        if (newSize < this.size) {
            throw new UnsupportedOperationException();
        }
        this.size = newSize;
    }

    @Override
    public int size() {
        return this.size;
    }

    private double update(int spot, int key, double value) {
        if (this.used == this.keys.length) {
            int capacity = this.keys.length * 3 / 2 + 1;
            this.keys = Arrays.copyOf(this.keys, capacity);
            this.values = Arrays.copyOf(this.values, capacity);
        }
        if (spot < this.used) {
            System.arraycopy(this.keys, spot, this.keys, spot + 1, this.used - spot);
            System.arraycopy(this.values, spot, this.values, spot + 1, this.used - spot);
        }
        ++this.used;
        this.keys[spot] = key;
        this.values[spot] = (float)value;
        return this.values[spot];
    }

    @Override
    public int used() {
        return this.used;
    }

    public void trim() {
        this.keys = Arrays.copyOf(this.keys, this.used);
        this.values = Arrays.copyOf(this.values, this.used);
    }

    @Override
    public double dot(Vector x) {
        double product = 0.0;
        for (int k = 0; k < this.used; ++k) {
            product += x.get(this.keys[k]) * this.values[k];
        }
        return product;
    }

    @Override
    public void scaleAndAddTo(double a, Vector y) {
        for (int k = 0; k < this.used; ++k) {
            y.add(this.keys[k], a * this.values[k]);
        }
    }

    @Override
    public boolean equals(Vector v, double epsilon) {
        throw new Error("not yet implemented");
    }

    @Override
    public Vector times(double scalar) {
        SparseVector y = new SparseVector(this.size);
        y.keys = Arrays.copyOf(this.keys, this.size);
        y.values = Arrays.copyOf(this.values, this.size);
        int i = 0;
        while (i < this.values.length) {
            int n = i++;
            y.values[n] = y.values[n] * scalar;
        }
        return y;
    }

    @Override
    public Vector timesEquals(double scalar) {
        int i = 0;
        while (i < this.values.length) {
            int n = i++;
            this.values[n] = this.values[n] * scalar;
        }
        return this;
    }

    public int[] keys() {
        return this.keys;
    }

    public double[] values() {
        return this.values;
    }
}

