/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.dht;

import edu.emory.mathcs.jtransforms.fft.DoubleFFT_1D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class DoubleDHT_1D {
    private int n;
    private DoubleFFT_1D fft;

    public DoubleDHT_1D(int n) {
        this.n = n;
        this.fft = new DoubleFFT_1D(n);
    }

    public void forward(double[] a) {
        this.forward(a, 0);
    }

    public void forward(final double[] a, final int offa) {
        if (this.n == 1) {
            return;
        }
        this.fft.realForward(a, offa);
        final double[] b = new double[this.n];
        System.arraycopy(a, offa, b, 0, this.n);
        int nd2 = this.n / 2;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && nd2 > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            nthreads = 2;
            int k1 = nd2 / nthreads;
            Future[] futures = new Future[nthreads];
            for (int i = 0; i < nthreads; ++i) {
                final int firstIdx = 1 + i * k1;
                final int lastIdx = i == nthreads - 1 ? nd2 : firstIdx + k1;
                futures[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            int idx1 = 2 * i;
                            int idx2 = idx1 + 1;
                            a[offa + i] = b[idx1] - b[idx2];
                            a[offa + ((DoubleDHT_1D)DoubleDHT_1D.this).n - i] = b[idx1] + b[idx2];
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 1; i < nd2; ++i) {
                int idx1 = 2 * i;
                int idx2 = idx1 + 1;
                a[offa + i] = b[idx1] - b[idx2];
                a[offa + this.n - i] = b[idx1] + b[idx2];
            }
        }
        if (this.n % 2 == 0) {
            a[offa + nd2] = b[1];
        } else {
            a[offa + nd2] = b[this.n - 1] - b[1];
            a[offa + nd2 + 1] = b[this.n - 1] + b[1];
        }
    }

    public void inverse(double[] a, boolean scale) {
        this.inverse(a, 0, scale);
    }

    public void inverse(double[] a, int offa, boolean scale) {
        if (this.n == 1) {
            return;
        }
        this.forward(a, offa);
        if (scale) {
            this.scale(this.n, a, offa);
        }
    }

    private void scale(double m, final double[] a, int offa) {
        final double norm = 1.0 / m;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.n >= ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            nthreads = 2;
            int k = this.n / nthreads;
            Future[] futures = new Future[nthreads];
            for (int i = 0; i < nthreads; ++i) {
                final int firstIdx = offa + i * k;
                final int lastIdx = i == nthreads - 1 ? offa + this.n : firstIdx + k;
                futures[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            int n = i++;
                            a[n] = a[n] * norm;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int lastIdx = offa + this.n;
            int i = offa;
            while (i < lastIdx) {
                int n = i++;
                a[n] = a[n] * norm;
            }
        }
    }
}

