/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.test.util;

import java.util.List;
import org.opengis.test.Assert;
import org.opengis.test.Validator;
import org.opengis.test.ValidatorContainer;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.LocalName;
import org.opengis.util.NameSpace;
import org.opengis.util.ScopedName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameValidator
extends Validator {
    public NameValidator(ValidatorContainer validatorContainer) {
        super(validatorContainer, "org.opengis.util");
    }

    public void validate(InternationalString internationalString) {
        if (internationalString == null) {
            return;
        }
        int n = internationalString.length();
        String string = internationalString.toString();
        this.mandatory("InternationalString: toString() should never returns null.", string);
        if (string != null) {
            Assert.assertEquals((String)"InternationalString: CharSequence length is inconsistent with toString().", (long)string.length(), (long)n);
            for (int i = 0; i < n; ++i) {
                Assert.assertEquals((String)"InternationalString: CharSequence is inconsistent with toString().", (long)string.charAt(i), (long)internationalString.charAt(i));
            }
        }
        this.mandatory("InternationalString: toString(Locale) should not return null.", internationalString.toString(null));
        Assert.assertEquals((String)"InternationalString: should be equals to itself.", (Object)internationalString, (Object)internationalString);
        Assert.assertEquals((String)"InternationalString: should be comparable to itself.", (long)0L, (long)internationalString.compareTo((Object)internationalString));
    }

    public void validate(NameSpace nameSpace) {
        if (nameSpace == null) {
            return;
        }
        GenericName genericName = nameSpace.name();
        this.mandatory("NameSpace: must have a name.", genericName);
        if (genericName != null) {
            NameSpace nameSpace2 = genericName.scope();
            this.mandatory("NameSpace: must have a scope.", nameSpace2);
            if (nameSpace2 != null) {
                Assert.assertTrue((String)"NameSpace: scope must be global.", (boolean)nameSpace2.isGlobal());
            }
            Assert.assertSame((String)"NameSpace: the name must be fully qualified.", (Object)genericName, (Object)genericName.toFullyQualifiedName());
        }
        if (nameSpace.isGlobal()) {
            Assert.assertInstanceOf("NameSpace: global namespace must have a local name.", LocalName.class, genericName);
        }
        this.validate(genericName, genericName.getParsedNames());
    }

    public void dispatch(GenericName genericName) {
        if (genericName instanceof LocalName) {
            this.validate((LocalName)genericName);
        }
        if (genericName instanceof ScopedName) {
            this.validate((ScopedName)genericName);
        }
    }

    private void validate(GenericName genericName, List<? extends LocalName> list) {
        this.mandatory("GenericName: getParsedNames() should not return null.", list);
        if (list != null) {
            Assert.assertFalse((String)"GenericName: getParsedNames() shall not return an empty list.", (boolean)list.isEmpty());
            int n = list.size();
            Assert.assertEquals((String)"GenericName: getParsedNames() list size should be equals to depth().", (long)n, (long)genericName.depth());
            Assert.assertSame((String)"GenericName: head() should be the first element in getParsedNames() list.", (Object)list.get(0), (Object)genericName.head());
            Assert.assertSame((String)"GenericName: tip() should be the last element in getParsedNames() list.", (Object)list.get(n - 1), (Object)genericName.tip());
        }
        GenericName genericName2 = genericName.toFullyQualifiedName();
        this.mandatory("GenericName: toFullyQualifiedName() should not return null.", genericName2);
        if (genericName2 != null) {
            Assert.assertEquals((String)"GenericName: toFullyQualifiedName() inconsistent with the global scope status.", (Object)genericName.scope().isGlobal(), (Object)(genericName2 == genericName ? 1 : 0));
        }
        String string = genericName.toString();
        this.mandatory("GenericName: toString() should never returns null.", string);
        if (string != null && genericName2 != null) {
            Assert.assertTrue((String)"GenericName: fully qualified name should end with the name.", (boolean)genericName2.toString().endsWith(string));
        }
        InternationalString internationalString = genericName.toInternationalString();
        this.validate(internationalString);
        if (internationalString != null && genericName2 != null) {
            Assert.assertTrue((String)"GenericName: fully qualified name should end with the name (localized version).", (boolean)genericName2.toInternationalString().toString().endsWith(internationalString.toString()));
        }
        Assert.assertEquals((String)"GenericName: should be equals to itself.", (Object)genericName, (Object)genericName);
        Assert.assertEquals((String)"GenericName: should be comparable to itself.", (long)0L, (long)genericName.compareTo((Object)genericName));
    }

    public void validate(LocalName localName) {
        if (localName == null) {
            return;
        }
        this.validate(localName.scope());
        List list = localName.getParsedNames();
        this.validate((GenericName)localName, list);
        if (list != null) {
            Assert.assertEquals((String)"LocalName: should have exactly one parsed name.", (long)1L, (long)list.size());
            Assert.assertSame((String)"LocalName: the parsed name element should be the enclosing local name.", (Object)localName, list.get(0));
        }
    }

    public void validate(ScopedName scopedName) {
        LocalName localName2;
        int n;
        if (scopedName == null) {
            return;
        }
        List list = scopedName.getParsedNames();
        this.validate((GenericName)scopedName, list);
        NameSpace nameSpace = scopedName.scope();
        this.validate(nameSpace);
        if (nameSpace != null) {
            Assert.assertSame((String)"ScopedName: head.scope should be same than scope.", (Object)nameSpace, (Object)scopedName.head().scope());
        }
        if (list != null) {
            n = nameSpace.isGlobal();
            for (LocalName localName2 : list) {
                Assert.assertNotNull((String)"ScopedName: getParsedNames() can not contain null element.", (Object)localName2);
                Assert.assertNotSame((String)"ScopedName: the enclosing scoped name can not be in any parsed name.", (Object)scopedName, (Object)localName2);
                Assert.assertEquals((String)"ScopedName: inconsistent value of isGlobal().", (Object)(n != 0), (Object)localName2.scope().isGlobal());
                n = 0;
                this.validate(localName2);
            }
        }
        n = scopedName.depth();
        GenericName genericName = scopedName.tail();
        this.mandatory("ScopedName: tail() should not return null.", genericName);
        if (genericName != null) {
            Assert.assertEquals((String)"ScopedName: tail() should have one less element than the enclosing scoped name.", (long)(n - 1), (long)genericName.depth());
            Assert.assertSame((String)"ScopedName: tip() and tail.tip() should be the same.", (Object)scopedName.tip(), (Object)genericName.tip());
            if (list != null) {
                Assert.assertEquals((String)"ScopedName: tail() should be defined as subList(1, depth).", list.subList(1, n), (Object)genericName.getParsedNames());
            }
        }
        localName2 = scopedName.path();
        this.mandatory("ScopedName: the path should not be null.", localName2);
        if (localName2 != null) {
            Assert.assertEquals((String)"ScopedName: path() should have one less element than the enclosing scoped name.", (long)(n - 1), (long)localName2.depth());
            Assert.assertSame((String)"ScopedName: head() and path.head() should be the same.", (Object)scopedName.head(), (Object)localName2.head());
            if (list != null) {
                Assert.assertEquals((String)"ScopedName: path() should be defined as subList(0, depth-1).", list.subList(0, n - 1), (Object)localName2.getParsedNames());
            }
        }
    }
}

