/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.com.sun.crypto.provider;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.ShortBufferException;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.openeuler.BGMJCEProvider;

abstract class PBES2Core
extends CipherSpi {
    private static final byte[] B0 = new byte[0];
    private static final int DEFAULT_SALT_LENGTH = 20;
    private static final int DEFAULT_COUNT = 4096;
    private static final String ECB_MODE = "ECB";
    private static final String CBC_MODE = "CBC";
    private static final Set<String> SUPPORTED_MODES = new HashSet<String>(Arrays.asList("ECB", "CBC"));
    private final Cipher cipher;
    private final int keyLength;
    private final int blkSize;
    private final SecretKeyFactory kdf;
    private final String pbeAlgo;
    private final String cipherAlgo;
    private int iCount = 4096;
    private byte[] salt = null;
    private IvParameterSpec ivSpec = null;
    private String mode;
    private String padding;

    PBES2Core(String kdfAlgo, String cipherAlgo, int keySize, String mode, String padding) throws NoSuchAlgorithmException, NoSuchPaddingException {
        this.cipherAlgo = cipherAlgo;
        this.mode = mode;
        this.padding = padding;
        this.keyLength = keySize * 8;
        this.pbeAlgo = "PBEWith" + kdfAlgo + "And" + cipherAlgo + "_" + this.keyLength + "/" + mode + "/" + padding;
        if (!cipherAlgo.equals("SM4")) {
            throw new NoSuchAlgorithmException("No Cipher implementation for " + this.pbeAlgo);
        }
        this.blkSize = keySize;
        this.cipher = Cipher.getInstance(cipherAlgo + "/" + mode + "/" + padding);
        this.kdf = SecretKeyFactory.getInstance("PBKDF2With" + kdfAlgo);
    }

    @Override
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        if (mode != null && !SUPPORTED_MODES.contains(mode.toUpperCase(Locale.ENGLISH))) {
            throw new NoSuchAlgorithmException("Invalid cipher mode: " + mode);
        }
    }

    @Override
    protected void engineSetPadding(String paddingScheme) throws NoSuchPaddingException {
        if (paddingScheme != null && !paddingScheme.equalsIgnoreCase("PKCS5Padding")) {
            throw new NoSuchPaddingException("Invalid padding scheme: " + paddingScheme);
        }
    }

    @Override
    protected int engineGetBlockSize() {
        return this.blkSize;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        return this.cipher.getOutputSize(inputLen);
    }

    @Override
    protected byte[] engineGetIV() {
        return this.cipher.getIV();
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        AlgorithmParameters params = null;
        if (this.salt == null) {
            this.salt = new byte[20];
            BGMJCEProvider.getRandom().nextBytes(this.salt);
            this.iCount = 4096;
        }
        if (!ECB_MODE.equals(this.mode) && this.ivSpec == null) {
            byte[] ivBytes = new byte[this.blkSize];
            BGMJCEProvider.getRandom().nextBytes(ivBytes);
            this.ivSpec = new IvParameterSpec(ivBytes);
        }
        PBEParameterSpec pbeSpec = new PBEParameterSpec(this.salt, this.iCount, this.ivSpec);
        try {
            params = AlgorithmParameters.getInstance(this.pbeAlgo);
            params.init(pbeSpec);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("BGMJCEProvider called, but not configured");
        }
        catch (InvalidParameterSpecException ipse) {
            throw new RuntimeException("PBEParameterSpec not supported");
        }
        return params;
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
        }
        catch (InvalidAlgorithmParameterException ie) {
            InvalidKeyException ike = new InvalidKeyException("requires PBE parameters");
            ike.initCause(ie);
            throw ike;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        SecretKey s;
        PBEKeySpec pbeSpec;
        byte[] passwdBytes;
        block33: {
            if (key == null) {
                throw new InvalidKeyException("Null key");
            }
            passwdBytes = key.getEncoded();
            char[] passwdChars = null;
            try {
                if (passwdBytes == null || !key.getAlgorithm().regionMatches(true, 0, "PBE", 0, 3)) {
                    throw new InvalidKeyException("Missing password");
                }
                if (key instanceof PBEKey) {
                    this.salt = ((PBEKey)key).getSalt();
                    if (this.salt != null && this.salt.length < 8) {
                        throw new InvalidAlgorithmParameterException("Salt must be at least 8 bytes long");
                    }
                    this.iCount = ((PBEKey)key).getIterationCount();
                    if (this.iCount == 0) {
                        this.iCount = 4096;
                    } else if (this.iCount < 0) {
                        throw new InvalidAlgorithmParameterException("Iteration count must be a positive number");
                    }
                }
                if (params == null) {
                    if (this.salt == null) {
                        this.salt = new byte[20];
                        random.nextBytes(this.salt);
                        this.iCount = 4096;
                    }
                    if (!(ECB_MODE.equals(this.mode) || opmode != 1 && opmode != 3)) {
                        byte[] ivBytes = new byte[this.blkSize];
                        random.nextBytes(ivBytes);
                        this.ivSpec = new IvParameterSpec(ivBytes);
                    }
                } else {
                    if (!(params instanceof PBEParameterSpec)) {
                        throw new InvalidAlgorithmParameterException("Wrong parameter type: PBE expected");
                    }
                    byte[] specSalt = ((PBEParameterSpec)params).getSalt();
                    if (specSalt != null && specSalt.length < 8) {
                        throw new InvalidAlgorithmParameterException("Salt must be at least 8 bytes long");
                    }
                    this.salt = specSalt;
                    int specICount = ((PBEParameterSpec)params).getIterationCount();
                    if (specICount == 0) {
                        specICount = 4096;
                    } else if (specICount < 0) {
                        throw new InvalidAlgorithmParameterException("Iteration count must be a positive number");
                    }
                    this.iCount = specICount;
                    AlgorithmParameterSpec specParams = ((PBEParameterSpec)params).getParameterSpec();
                    if (specParams != null) {
                        if (specParams instanceof IvParameterSpec) {
                            this.ivSpec = (IvParameterSpec)specParams;
                        } else {
                            throw new InvalidAlgorithmParameterException("Wrong parameter type: IV expected");
                        }
                    }
                    if (ECB_MODE.equals(this.mode)) {
                        if (this.ivSpec != null) {
                            throw new InvalidAlgorithmParameterException("ECB mode cannot use IV");
                        }
                    } else if (this.ivSpec == null) {
                        if (opmode == 1 || opmode == 3) {
                            byte[] ivBytes = new byte[this.blkSize];
                            random.nextBytes(ivBytes);
                            this.ivSpec = new IvParameterSpec(ivBytes);
                        } else {
                            throw new InvalidAlgorithmParameterException("Missing parameter type: IV expected");
                        }
                    }
                }
                passwdChars = new char[passwdBytes.length];
                for (int i = 0; i < passwdChars.length; ++i) {
                    passwdChars[i] = (char)(passwdBytes[i] & 0x7F);
                }
                pbeSpec = new PBEKeySpec(passwdChars, this.salt, this.iCount, this.keyLength);
                if (passwdChars == null) break block33;
            }
            catch (Throwable throwable) {
                if (passwdChars != null) {
                    Arrays.fill(passwdChars, '\u0000');
                }
                if (passwdBytes != null) {
                    Arrays.fill(passwdBytes, (byte)0);
                }
                throw throwable;
            }
            Arrays.fill(passwdChars, '\u0000');
        }
        if (passwdBytes != null) {
            Arrays.fill(passwdBytes, (byte)0);
        }
        try {
            s = this.kdf.generateSecret(pbeSpec);
        }
        catch (InvalidKeySpecException ikse) {
            InvalidKeyException ike = new InvalidKeyException("Cannot construct PBE key");
            ike.initCause(ikse);
            throw ike;
        }
        byte[] derivedKey = s.getEncoded();
        SecretKeySpec cipherKey = new SecretKeySpec(derivedKey, this.cipherAlgo);
        this.cipher.init(opmode, (Key)cipherKey, this.ivSpec, random);
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        PBEParameterSpec pbeSpec = null;
        if (params != null) {
            try {
                pbeSpec = params.getParameterSpec(PBEParameterSpec.class);
            }
            catch (InvalidParameterSpecException ipse) {
                throw new InvalidAlgorithmParameterException("Wrong parameter type: PBE expected");
            }
        }
        this.engineInit(opmode, key, pbeSpec, random);
    }

    @Override
    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        if (inputLen == 0 || input == null) {
            return B0;
        }
        return this.cipher.update(input, inputOffset, inputLen);
    }

    @Override
    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        if (inputLen == 0 || input == null) {
            return 0;
        }
        return this.cipher.update(input, inputOffset, inputLen, output, outputOffset);
    }

    @Override
    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        if (inputLen == 0 || input == null) {
            return this.cipher.doFinal();
        }
        return this.cipher.doFinal(input, inputOffset, inputLen);
    }

    @Override
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (inputLen == 0 || input == null) {
            byte[] result = this.cipher.doFinal();
            int length = result.length;
            if (outputOffset + length > output.length) {
                throw new IllegalArgumentException("Bad arguments");
            }
            System.arraycopy(result, 0, output, outputOffset, length);
            return length;
        }
        return this.cipher.doFinal(input, inputOffset, inputLen, output, outputOffset);
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        return this.keyLength;
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        return this.cipher.wrap(key);
    }

    @Override
    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        return this.cipher.unwrap(wrappedKey, wrappedKeyAlgorithm, wrappedKeyType);
    }

    public static final class HmacSM3AndSM4_128_ECB_PKCS5Padding
    extends PBES2Core {
        public HmacSM3AndSM4_128_ECB_PKCS5Padding() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super("HmacSM3", "SM4", 16, PBES2Core.ECB_MODE, "PKCS5Padding");
        }
    }

    public static final class HmacSM3AndSM4_128_CBC_PKCS5Padding
    extends PBES2Core {
        public HmacSM3AndSM4_128_CBC_PKCS5Padding() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super("HmacSM3", "SM4", 16, PBES2Core.CBC_MODE, "PKCS5Padding");
        }
    }
}

