/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.com.sun.crypto.provider;

import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.PBEKeySpec;
import org.openeuler.com.sun.crypto.provider.PBEKey;

abstract class PBEKeyFactory
extends SecretKeyFactorySpi {
    private String type;
    private static HashSet<String> validTypes = new HashSet(6);

    private PBEKeyFactory(String keytype) {
        this.type = keytype;
    }

    @Override
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (!(keySpec instanceof PBEKeySpec)) {
            throw new InvalidKeySpecException("Invalid key spec");
        }
        return new PBEKey((PBEKeySpec)keySpec, this.type);
    }

    @Override
    protected KeySpec engineGetKeySpec(SecretKey key, Class<?> keySpecCl) throws InvalidKeySpecException {
        if (key instanceof SecretKey && validTypes.contains(key.getAlgorithm().toUpperCase(Locale.ENGLISH)) && key.getFormat().equalsIgnoreCase("RAW")) {
            if (keySpecCl != null && PBEKeySpec.class.isAssignableFrom(keySpecCl)) {
                byte[] passwdBytes = key.getEncoded();
                char[] passwdChars = new char[passwdBytes.length];
                for (int i = 0; i < passwdChars.length; ++i) {
                    passwdChars[i] = (char)(passwdBytes[i] & 0x7F);
                }
                PBEKeySpec ret = new PBEKeySpec(passwdChars);
                Arrays.fill(passwdChars, ' ');
                Arrays.fill(passwdBytes, (byte)0);
                return ret;
            }
            throw new InvalidKeySpecException("Invalid key spec");
        }
        throw new InvalidKeySpecException("Invalid key format/algorithm");
    }

    @Override
    protected SecretKey engineTranslateKey(SecretKey key) throws InvalidKeyException {
        try {
            if (key != null && validTypes.contains(key.getAlgorithm().toUpperCase(Locale.ENGLISH)) && key.getFormat().equalsIgnoreCase("RAW")) {
                if (key instanceof PBEKey) {
                    return key;
                }
                PBEKeySpec pbeKeySpec = (PBEKeySpec)this.engineGetKeySpec(key, PBEKeySpec.class);
                return this.engineGenerateSecret(pbeKeySpec);
            }
            throw new InvalidKeyException("Invalid key format/algorithm");
        }
        catch (InvalidKeySpecException ikse) {
            throw new InvalidKeyException("Cannot translate key: " + ikse.getMessage());
        }
    }

    static {
        validTypes.add("PBEWithHmacSM3AndSM4_128/ECB/PKCS5Padding".toUpperCase(Locale.ENGLISH));
        validTypes.add("PBEWithHmacSM3AndSM4_128/CBC/PKCS5Padding".toUpperCase(Locale.ENGLISH));
    }

    public static final class PBEWithHmacSM3AndSM4_128_CBC_PKCS5Padding
    extends PBEKeyFactory {
        public PBEWithHmacSM3AndSM4_128_CBC_PKCS5Padding() {
            super("PBEWithHmacSM3AndSM4_128/CBC/PKCS5Padding");
        }
    }

    public static final class PBEWithHmacSM3AndSM4_128_ECB_PKCS5Padding
    extends PBEKeyFactory {
        public PBEWithHmacSM3AndSM4_128_ECB_PKCS5Padding() {
            super("PBEWithHmacSM3AndSM4_128/ECB/PKCS5Padding");
        }
    }
}

