/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api.meta;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.IdentifierNamespace;
import org.opendaylight.yangtools.yang.model.api.meta.ModelStatement;

public interface EffectiveStatement<A, D extends DeclaredStatement<A>>
extends ModelStatement<A> {
    public @Nullable D getDeclared();

    public <K, V, N extends IdentifierNamespace<K, V>> @Nullable V get(@NonNull Class<N> var1, @NonNull K var2);

    public <K, V, N extends IdentifierNamespace<K, V>> @Nullable Map<K, V> getAll(@NonNull Class<N> var1);

    default public <K, V, N extends IdentifierNamespace<K, V>> @NonNull Map<K, V> findAll(@NonNull Class<N> namespace) {
        Map<K, V> map = this.getAll(Objects.requireNonNull(namespace));
        return map == null ? ImmutableMap.of() : map;
    }

    public @NonNull Collection<? extends EffectiveStatement<?, ?>> effectiveSubstatements();

    @Beta
    default public <T> Optional<T> findFirstEffectiveSubstatement(@NonNull Class<T> type) {
        return this.effectiveSubstatements().stream().filter(type::isInstance).findFirst().map(type::cast);
    }

    @Beta
    default public <V, T extends EffectiveStatement<V, ?>> Optional<V> findFirstEffectiveSubstatementArgument(@NonNull Class<T> type) {
        return this.findFirstEffectiveSubstatement(type).map(ModelStatement::argument);
    }

    @Beta
    default public <T extends EffectiveStatement<?, ?>> Stream<T> streamEffectiveSubstatements(@NonNull Class<T> type) {
        return this.effectiveSubstatements().stream().filter(type::isInstance).map(type::cast);
    }
}

