/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AugmentationTarget;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.MandatoryAware;

public interface ChoiceSchemaNode
extends DataSchemaNode,
AugmentationTarget,
MandatoryAware {
    public SortedMap<QName, CaseSchemaNode> getCases();

    default public Optional<CaseSchemaNode> findCase(QName qname) {
        return Optional.ofNullable(this.getCases().get(Objects.requireNonNull(qname)));
    }

    @Beta
    default public List<CaseSchemaNode> findCaseNodes(String localname) {
        return (List)this.getCases().values().stream().filter(node -> localname.equals(node.getQName().getLocalName())).collect(ImmutableList.toImmutableList());
    }

    @Beta
    default public Optional<DataSchemaNode> findDataSchemaChild(QName qname) {
        Objects.requireNonNull(qname);
        for (CaseSchemaNode caseNode : this.getCases().values()) {
            Optional<DataSchemaNode> child = caseNode.findDataChildByName(qname);
            if (!child.isPresent()) continue;
            return child;
        }
        return Optional.empty();
    }

    @Deprecated
    default public CaseSchemaNode getCaseNodeByName(QName qname) {
        return (CaseSchemaNode)this.getCases().get(qname);
    }

    public Optional<CaseSchemaNode> getDefaultCase();
}

