/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util.codec;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.util.codec.QNameCodecUtil;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;

@Beta
@NonNullByDefault
public final class IdentityCodecUtil {
    private IdentityCodecUtil() {
    }

    public static IdentitySchemaNode parseIdentity(String value, EffectiveModelContext schemaContext, Function<String, QNameModule> prefixToModule) {
        QName qname = QNameCodecUtil.decodeQName(value, prefixToModule);
        Optional optModule = schemaContext.findModule(qname.getModule());
        Preconditions.checkState((boolean)optModule.isPresent(), (String)"Parsed QName %s refers to a non-existent module", (Object)qname);
        for (IdentitySchemaNode identity : ((Module)optModule.get()).getIdentities()) {
            if (!qname.equals((Object)identity.getQName())) continue;
            return identity;
        }
        throw new IllegalArgumentException("Parsed QName " + qname + " does not refer to a valid identity");
    }
}

