/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import com.google.common.base.Verify;
import java.io.IOException;
import org.opendaylight.yangtools.rfc7952.data.api.StreamWriterMetadataExtension;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.util.CaseNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.CompositeNodeDataWithSchema;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;

final class ChoiceNodeDataWithSchema
extends CompositeNodeDataWithSchema<ChoiceSchemaNode> {
    private CaseNodeDataWithSchema caseNodeDataWithSchema;

    ChoiceNodeDataWithSchema(ChoiceSchemaNode schema) {
        super(schema);
    }

    CaseNodeDataWithSchema addCompositeChild(DataSchemaNode schema, CompositeNodeDataWithSchema.ChildReusePolicy policy) {
        Verify.verify((boolean)(schema instanceof CaseSchemaNode), (String)"Unexpected schema %s", (Object)schema);
        return this.addCompositeChild((CaseSchemaNode)schema, policy);
    }

    CaseNodeDataWithSchema addCompositeChild(CaseSchemaNode schema, CompositeNodeDataWithSchema.ChildReusePolicy policy) {
        CaseNodeDataWithSchema newChild;
        this.caseNodeDataWithSchema = newChild = new CaseNodeDataWithSchema(schema);
        this.addCompositeChild(newChild, policy);
        return newChild;
    }

    CaseNodeDataWithSchema getCase() {
        return this.caseNodeDataWithSchema;
    }

    @Override
    public void write(NormalizedNodeStreamWriter writer, StreamWriterMetadataExtension metaWriter) throws IOException {
        writer.nextDataSchemaNode(this.getSchema());
        writer.startChoiceNode(this.provideNodeIdentifier(), this.childSizeHint());
        super.write(writer, metaWriter);
        writer.endNode();
    }
}

