/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.util.AbstractMixinContextNode;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextNode;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;

final class ChoiceNodeContextNode
extends AbstractMixinContextNode<YangInstanceIdentifier.NodeIdentifier> {
    private final ImmutableMap<YangInstanceIdentifier.PathArgument, DataSchemaContextNode<?>> byArg;
    private final ImmutableMap<QName, DataSchemaContextNode<?>> byQName;
    private final ImmutableMap<DataSchemaContextNode<?>, QName> childToCase;

    ChoiceNodeContextNode(ChoiceSchemaNode schema) {
        super(YangInstanceIdentifier.NodeIdentifier.create((QName)schema.getQName()), (DataSchemaNode)schema);
        ImmutableMap.Builder childToCaseBuilder = ImmutableMap.builder();
        ImmutableMap.Builder byQNameBuilder = ImmutableMap.builder();
        ImmutableMap.Builder byArgBuilder = ImmutableMap.builder();
        for (CaseSchemaNode caze : schema.getCases()) {
            for (DataSchemaNode cazeChild : caze.getChildNodes()) {
                DataSchemaContextNode<?> childOp = DataSchemaContextNode.of(cazeChild);
                byArgBuilder.put((Object)((YangInstanceIdentifier.PathArgument)childOp.getIdentifier()), childOp);
                childToCaseBuilder.put(childOp, (Object)caze.getQName());
                for (QName qname : childOp.getQNameIdentifiers()) {
                    byQNameBuilder.put((Object)qname, childOp);
                }
            }
        }
        this.childToCase = childToCaseBuilder.build();
        this.byQName = byQNameBuilder.build();
        this.byArg = byArgBuilder.build();
    }

    @Override
    public DataSchemaContextNode<?> getChild(YangInstanceIdentifier.PathArgument child) {
        return (DataSchemaContextNode)((Object)this.byArg.get((Object)child));
    }

    @Override
    public DataSchemaContextNode<?> getChild(QName child) {
        return (DataSchemaContextNode)((Object)this.byQName.get((Object)child));
    }

    @Override
    protected Set<QName> getQNameIdentifiers() {
        return this.byQName.keySet();
    }

    @Override
    protected DataSchemaContextNode<?> enterChild(QName child, SchemaInferenceStack stack) {
        return this.pushToStack(this.getChild(child), stack);
    }

    @Override
    protected DataSchemaContextNode<?> enterChild(YangInstanceIdentifier.PathArgument child, SchemaInferenceStack stack) {
        return this.pushToStack(this.getChild(child), stack);
    }

    @Override
    protected void pushToStack(@NonNull SchemaInferenceStack stack) {
        stack.enterChoice(((YangInstanceIdentifier.NodeIdentifier)this.getIdentifier()).getNodeType());
    }

    private @Nullable DataSchemaContextNode<?> pushToStack(@Nullable DataSchemaContextNode<?> child, @NonNull SchemaInferenceStack stack) {
        if (child != null) {
            QName caseName = (QName)Verify.verifyNotNull((Object)((QName)this.childToCase.get(child)), (String)"No case statement for %s in %s", (Object[])new Object[]{child, this});
            stack.enterSchemaTree(caseName);
            child.pushToStack(stack);
        }
        return child;
    }
}

