/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.opendaylight.yangtools.rfc7952.data.api.StreamWriterMetadataExtension;
import org.opendaylight.yangtools.rfc8528.data.api.MountPointContextFactory;
import org.opendaylight.yangtools.rfc8528.data.api.MountPointIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.util.CompositeNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.MountPointData;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;

@Beta
public abstract class AbstractMountPointDataWithSchema<T extends DataSchemaNode>
extends CompositeNodeDataWithSchema<T> {
    private MountPointData mountedData;

    AbstractMountPointDataWithSchema(T schema) {
        super(schema);
    }

    @Override
    public void write(NormalizedNodeStreamWriter writer, StreamWriterMetadataExtension metaWriter) throws IOException {
        super.write(writer, metaWriter);
        if (this.mountedData != null) {
            this.mountedData.write(writer);
        }
    }

    public final MountPointData getMountPointData(MountPointIdentifier label, MountPointContextFactory factory) {
        if (this.mountedData != null) {
            MountPointIdentifier existing = (MountPointIdentifier)this.mountedData.getIdentifier();
            Preconditions.checkState((boolean)label.equals((Object)existing), (String)"Mismatched mount label {}, already have {}", (Object)label, (Object)existing);
        } else {
            this.mountedData = new MountPointData(label, factory);
        }
        return this.mountedData;
    }
}

