/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util.codec;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.util.codec.CodecCache;
import org.opendaylight.yangtools.yang.data.util.codec.TypeAwareCodec;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.TypedSchemaNode;
import org.opendaylight.yangtools.yang.model.api.type.BinaryTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BooleanTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.DecimalTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EmptyTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.IdentityrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.InstanceIdentifierTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.IntegerTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.StringTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnknownTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnsignedIntegerTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.SchemaContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class AbstractCodecFactory<T extends TypeAwareCodec<?, ?, ?>> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCodecFactory.class);
    private final CodecCache<T> cache;
    private final SchemaContext schemaContext;

    protected AbstractCodecFactory(SchemaContext schemaContext, CodecCache<T> cache) {
        this.schemaContext = (SchemaContext)Preconditions.checkNotNull((Object)schemaContext);
        this.cache = (CodecCache)Preconditions.checkNotNull(cache);
    }

    public final SchemaContext getSchemaContext() {
        return this.schemaContext;
    }

    public final T codecFor(TypedSchemaNode schema) {
        TypeDefinition type = schema.getType();
        TypeAwareCodec ret = (TypeAwareCodec)this.cache.lookupSimple(type);
        if (ret != null) {
            LOG.trace("Type {} hit simple {}", (Object)type, (Object)ret);
            return (T)ret;
        }
        ret = (TypeAwareCodec)this.cache.lookupComplex(schema);
        if (ret != null) {
            LOG.trace("Type {} hit complex {}", (Object)type, (Object)ret);
            return (T)ret;
        }
        ret = this.getSimpleCodecFor(type);
        if (ret != null) {
            LOG.trace("Type {} miss simple {}", (Object)type, (Object)ret);
            return (T)ret;
        }
        ret = this.createComplexCodecFor(schema, type);
        LOG.trace("Type {} miss complex {}", (Object)type, (Object)ret);
        return (T)this.cache.getComplex(schema, ret);
    }

    protected abstract T binaryCodec(BinaryTypeDefinition var1);

    protected abstract T booleanCodec(BooleanTypeDefinition var1);

    protected abstract T bitsCodec(BitsTypeDefinition var1);

    protected abstract T emptyCodec(EmptyTypeDefinition var1);

    protected abstract T enumCodec(EnumTypeDefinition var1);

    protected abstract T identityRefCodec(IdentityrefTypeDefinition var1, QNameModule var2);

    protected abstract T instanceIdentifierCodec(InstanceIdentifierTypeDefinition var1);

    protected abstract T intCodec(IntegerTypeDefinition var1);

    protected abstract T decimalCodec(DecimalTypeDefinition var1);

    protected abstract T stringCodec(StringTypeDefinition var1);

    protected abstract T uintCodec(UnsignedIntegerTypeDefinition var1);

    protected abstract T unionCodec(UnionTypeDefinition var1, List<T> var2);

    protected abstract T unknownCodec(UnknownTypeDefinition var1);

    private T getSimpleCodecFor(TypeDefinition<?> type) {
        T ret;
        if (type instanceof EmptyTypeDefinition) {
            return this.emptyCodec((EmptyTypeDefinition)type);
        }
        if (type instanceof UnknownTypeDefinition) {
            return this.unknownCodec((UnknownTypeDefinition)type);
        }
        if (type instanceof StringTypeDefinition) {
            ret = this.stringCodec((StringTypeDefinition)type);
        } else if (type instanceof IntegerTypeDefinition) {
            ret = this.intCodec((IntegerTypeDefinition)type);
        } else if (type instanceof UnsignedIntegerTypeDefinition) {
            ret = this.uintCodec((UnsignedIntegerTypeDefinition)type);
        } else if (type instanceof BooleanTypeDefinition) {
            ret = this.booleanCodec((BooleanTypeDefinition)type);
        } else if (type instanceof DecimalTypeDefinition) {
            ret = this.decimalCodec((DecimalTypeDefinition)type);
        } else if (type instanceof EnumTypeDefinition) {
            ret = this.enumCodec((EnumTypeDefinition)type);
        } else if (type instanceof BitsTypeDefinition) {
            ret = this.bitsCodec((BitsTypeDefinition)type);
        } else if (type instanceof UnionTypeDefinition) {
            UnionTypeDefinition union = (UnionTypeDefinition)type;
            if (!AbstractCodecFactory.isSimpleUnion(union)) {
                return null;
            }
            ret = this.createSimpleUnion(union);
        } else if (type instanceof BinaryTypeDefinition) {
            ret = this.binaryCodec((BinaryTypeDefinition)type);
        } else {
            if (type instanceof InstanceIdentifierTypeDefinition) {
                return this.instanceIdentifierCodec((InstanceIdentifierTypeDefinition)type);
            }
            return null;
        }
        return (T)((TypeAwareCodec)this.cache.getSimple(type, Verify.verifyNotNull(ret)));
    }

    private static boolean isSimpleUnion(UnionTypeDefinition union) {
        for (TypeDefinition t : union.getTypes()) {
            if (!(t instanceof IdentityrefTypeDefinition) && !(t instanceof LeafrefTypeDefinition) && (!(t instanceof UnionTypeDefinition) || AbstractCodecFactory.isSimpleUnion((UnionTypeDefinition)t))) continue;
            LOG.debug("Type {} has non-simple subtype", (Object)t);
            return false;
        }
        LOG.debug("Type {} is simple", (Object)union);
        return true;
    }

    private T createComplexCodecFor(TypedSchemaNode schema, TypeDefinition<?> type) {
        if (type instanceof UnionTypeDefinition) {
            return this.createComplexUnion(schema, (UnionTypeDefinition)type);
        }
        if (type instanceof LeafrefTypeDefinition) {
            TypeDefinition target = SchemaContextUtil.getBaseTypeForLeafRef((LeafrefTypeDefinition)((LeafrefTypeDefinition)type), (SchemaContext)this.schemaContext, (SchemaNode)schema);
            Verify.verifyNotNull((Object)target, (String)"Unable to find base type for leafref node %s type %s.", (Object[])new Object[]{schema.getPath(), target});
            T ret = this.getSimpleCodecFor(target);
            return ret != null ? ret : this.createComplexCodecFor(schema, target);
        }
        if (type instanceof IdentityrefTypeDefinition) {
            return this.identityRefCodec((IdentityrefTypeDefinition)type, schema.getQName().getModule());
        }
        throw new IllegalArgumentException("Unsupported type " + type);
    }

    private T createSimpleUnion(UnionTypeDefinition union) {
        List types = union.getTypes();
        ArrayList<TypeAwareCodec> codecs = new ArrayList<TypeAwareCodec>(types.size());
        for (TypeDefinition type : types) {
            TypeAwareCodec codec = (TypeAwareCodec)this.cache.lookupSimple(type);
            if (codec == null) {
                codec = (TypeAwareCodec)Verify.verifyNotNull(this.getSimpleCodecFor(type), (String)"Type %s did not resolve to a simple codec", (Object[])new Object[]{type});
            }
            codecs.add(codec);
        }
        return (T)this.unionCodec(union, codecs);
    }

    private T createComplexUnion(TypedSchemaNode schema, UnionTypeDefinition union) {
        List types = union.getTypes();
        ArrayList<Object> codecs = new ArrayList<Object>(types.size());
        for (TypeDefinition type : types) {
            TypeAwareCodec codec = (TypeAwareCodec)this.cache.lookupSimple(type);
            if (codec == null && (codec = this.getSimpleCodecFor(type)) == null) {
                codec = this.createComplexCodecFor(schema, type);
            }
            codecs.add(Verify.verifyNotNull((Object)codec, (String)"Schema %s subtype %s has no codec", (Object[])new Object[]{schema, type}));
        }
        return (T)this.unionCodec(union, codecs);
    }
}

