/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.util.EmptyConstraintDefinition;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchema;
import org.opendaylight.yangtools.yang.model.api.ConstraintDefinition;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.UsesNode;

public final class ContainerSchemaNodes {
    private ContainerSchemaNodes() {
    }

    @Beta
    public static ContainerSchemaNode forNotification(NotificationDefinition notification) {
        return new NotificationContainerSchemaNode(notification);
    }

    @Beta
    public static ContainerSchemaNode forRPC(RpcDefinition rpc) {
        return new RpcContainerSchemaNode(rpc);
    }

    private static final class NotificationContainerSchemaNode
    extends AbstractContainerSchemaNode {
        private final NotificationDefinition notification;
        private final Map<QName, DataSchemaNode> mapNodes;

        private NotificationContainerSchemaNode(NotificationDefinition notification) {
            super((SchemaNode)notification);
            this.notification = notification;
            this.mapNodes = Maps.uniqueIndex((Iterable)notification.getChildNodes(), SchemaNode::getQName);
        }

        public Set<NotificationDefinition> getNotifications() {
            return ImmutableSet.of((Object)this.notification);
        }

        public Set<AugmentationSchema> getAvailableAugmentations() {
            return this.notification.getAvailableAugmentations();
        }

        public Set<TypeDefinition<?>> getTypeDefinitions() {
            return this.notification.getTypeDefinitions();
        }

        public Collection<DataSchemaNode> getChildNodes() {
            return this.notification.getChildNodes();
        }

        public Set<GroupingDefinition> getGroupings() {
            return this.notification.getGroupings();
        }

        public DataSchemaNode getDataChildByName(QName name) {
            return this.mapNodes.get(name);
        }

        public boolean isAddedByUses() {
            return false;
        }
    }

    private static final class RpcContainerSchemaNode
    extends AbstractContainerSchemaNode {
        private final RpcDefinition rpcDefinition;

        private RpcContainerSchemaNode(RpcDefinition rpcDefinition) {
            super((SchemaNode)rpcDefinition);
            this.rpcDefinition = rpcDefinition;
        }

        public Set<GroupingDefinition> getGroupings() {
            return this.rpcDefinition.getGroupings();
        }

        public Set<TypeDefinition<?>> getTypeDefinitions() {
            return this.rpcDefinition.getTypeDefinitions();
        }

        public Set<AugmentationSchema> getAvailableAugmentations() {
            return ImmutableSet.of();
        }

        public Collection<DataSchemaNode> getChildNodes() {
            ContainerSchemaNode input = this.rpcDefinition.getInput();
            ContainerSchemaNode output = this.rpcDefinition.getOutput();
            if (input == null && output == null) {
                return ImmutableList.of();
            }
            if (input != null && output != null) {
                return ImmutableList.of((Object)input, (Object)output);
            }
            if (input != null) {
                return ImmutableList.of((Object)input);
            }
            return ImmutableList.of((Object)output);
        }

        public DataSchemaNode getDataChildByName(QName name) {
            switch (name.getLocalName()) {
                case "input": {
                    return this.rpcDefinition.getInput();
                }
                case "output": {
                    return this.rpcDefinition.getOutput();
                }
            }
            return null;
        }

        public boolean isAddedByUses() {
            return false;
        }
    }

    private static abstract class AbstractContainerSchemaNode
    implements ContainerSchemaNode {
        private final SchemaNode schemaNode;

        private AbstractContainerSchemaNode(SchemaNode schemaNode) {
            this.schemaNode = schemaNode;
        }

        public boolean isPresenceContainer() {
            return false;
        }

        public Set<UsesNode> getUses() {
            return ImmutableSet.of();
        }

        public boolean isAugmenting() {
            return false;
        }

        public boolean isConfiguration() {
            return false;
        }

        public ConstraintDefinition getConstraints() {
            return EmptyConstraintDefinition.create(false);
        }

        @Nonnull
        public QName getQName() {
            return this.schemaNode.getQName();
        }

        @Nonnull
        public SchemaPath getPath() {
            return this.schemaNode.getPath();
        }

        @Nullable
        public String getDescription() {
            return this.schemaNode.getDescription();
        }

        @Nullable
        public String getReference() {
            return this.schemaNode.getReference();
        }

        @Nonnull
        public Status getStatus() {
            return this.schemaNode.getStatus();
        }

        @Nonnull
        public List<UnknownSchemaNode> getUnknownSchemaNodes() {
            return ImmutableList.of();
        }
    }
}

