/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;

@Beta
public abstract class AbstractNodeDataWithSchema {
    private final DataSchemaNode schema;
    private Map<QName, String> attributes;

    public AbstractNodeDataWithSchema(DataSchemaNode schema) {
        this.schema = (DataSchemaNode)Preconditions.checkNotNull((Object)schema);
    }

    public final DataSchemaNode getSchema() {
        return this.schema;
    }

    public final void setAttributes(Map<QName, String> attributes) {
        Preconditions.checkState((this.attributes == null ? 1 : 0) != 0, (String)"Node '%s' has already set its attributes to %s.", (Object)this.getSchema().getQName(), this.attributes);
        this.attributes = attributes;
    }

    public final Map<QName, String> getAttributes() {
        return this.attributes;
    }

    public abstract void write(NormalizedNodeStreamWriter var1) throws IOException;

    protected final YangInstanceIdentifier.NodeIdentifier provideNodeIdentifier() {
        return YangInstanceIdentifier.NodeIdentifier.create((QName)this.schema.getQName());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this.schema);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractNodeDataWithSchema other = (AbstractNodeDataWithSchema)obj;
        return this.schema.equals(other.schema);
    }
}

