/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.net.URI;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;

abstract class AbstractNamespaceCodec {
    private static final Splitter COLON_SPLITTER = Splitter.on((char)':');

    AbstractNamespaceCodec() {
    }

    @Nullable
    protected abstract String prefixForNamespace(@Nonnull URI var1);

    @Nullable
    protected abstract QName createQName(@Nonnull String var1, @Nonnull String var2);

    private static String getIdAndPrefixAsStr(String pathPart) {
        int predicateStartIndex = pathPart.indexOf(91);
        return predicateStartIndex == -1 ? pathPart : pathPart.substring(0, predicateStartIndex);
    }

    protected final StringBuilder appendQName(StringBuilder sb, QName qname) {
        String prefix = this.prefixForNamespace(qname.getNamespace());
        Preconditions.checkArgument((prefix != null ? 1 : 0) != 0, (String)"Failed to map QName %s to prefix", (Object)qname);
        sb.append(prefix).append(':').append(qname.getLocalName());
        return sb;
    }

    protected StringBuilder appendQName(StringBuilder sb, QName qname, @Nullable QNameModule lastModule) {
        return this.appendQName(sb, qname);
    }

    protected final QName parseQName(String str) {
        String identifier;
        String prefix;
        String xPathPartTrimmed = AbstractNamespaceCodec.getIdAndPrefixAsStr(str).trim();
        Iterator it = COLON_SPLITTER.split((CharSequence)xPathPartTrimmed).iterator();
        if (!it.hasNext()) {
            return null;
        }
        String first = ((String)it.next()).trim();
        if (first.isEmpty()) {
            return null;
        }
        if (it.hasNext()) {
            prefix = first;
            identifier = ((String)it.next()).trim();
        } else {
            prefix = "";
            identifier = first;
        }
        if (identifier.isEmpty()) {
            return null;
        }
        return this.createQName(prefix, identifier);
    }
}

