/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api.schema.tree.spi;

import com.google.common.base.MoreObjects;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.util.MapAdaptor;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.AbstractContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.TreeNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.Version;

abstract class AbstractModifiedContainerNode
extends AbstractContainerNode {
    private final Map<YangInstanceIdentifier.PathArgument, TreeNode> children;
    private final Version subtreeVersion;

    protected AbstractModifiedContainerNode(NormalizedNode<?, ?> data, Version version, Map<YangInstanceIdentifier.PathArgument, TreeNode> children, Version subtreeVersion) {
        super(data, version);
        this.subtreeVersion = Objects.requireNonNull(subtreeVersion);
        this.children = Objects.requireNonNull(children);
    }

    protected final TreeNode getModifiedChild(YangInstanceIdentifier.PathArgument childId) {
        return this.children.get(childId);
    }

    protected final Map<YangInstanceIdentifier.PathArgument, TreeNode> snapshotChildren() {
        return MapAdaptor.getDefaultInstance().takeSnapshot(this.children);
    }

    @Override
    public final Version getSubtreeVersion() {
        return this.subtreeVersion;
    }

    @Override
    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
        return helper.add("subtreeVersion", (Object)this.subtreeVersion).add("children", this.children);
    }
}

