/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api.schema.tree;

import com.google.common.annotations.Beta;
import java.util.Iterator;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.CursorAwareDataTreeModification;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateNodes;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModification;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModificationCursor;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DefaultDataTreeCandidate;
import org.opendaylight.yangtools.yang.data.api.schema.tree.NormalizedNodeDataTreeCandidateNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class DataTreeCandidates {
    private static final Logger LOG = LoggerFactory.getLogger(DataTreeCandidates.class);

    private DataTreeCandidates() {
    }

    public static @NonNull DataTreeCandidate newDataTreeCandidate(YangInstanceIdentifier rootPath, DataTreeCandidateNode rootNode) {
        return new DefaultDataTreeCandidate(rootPath, rootNode);
    }

    public static @NonNull DataTreeCandidate fromNormalizedNode(YangInstanceIdentifier rootPath, NormalizedNode<?, ?> node) {
        return new DefaultDataTreeCandidate(rootPath, new NormalizedNodeDataTreeCandidateNode(node));
    }

    public static void applyToCursor(DataTreeModificationCursor cursor, DataTreeCandidate candidate) {
        DataTreeCandidateNodes.applyToCursor(cursor, candidate.getRootNode());
    }

    public static void applyToModification(DataTreeModification modification, DataTreeCandidate candidate) {
        if (modification instanceof CursorAwareDataTreeModification) {
            DataTreeCandidates.applyToCursorAwareModification((CursorAwareDataTreeModification)modification, candidate);
            return;
        }
        DataTreeCandidateNode node = candidate.getRootNode();
        YangInstanceIdentifier path = candidate.getRootPath();
        switch (node.getModificationType()) {
            case DELETE: {
                modification.delete(path);
                LOG.debug("Modification {} deleted path {}", (Object)modification, (Object)path);
                break;
            }
            case SUBTREE_MODIFIED: {
                LOG.debug("Modification {} modified path {}", (Object)modification, (Object)path);
                NodeIterator iterator = new NodeIterator(null, path, node.getChildNodes().iterator());
                while ((iterator = iterator.next(modification)) != null) {
                }
                break;
            }
            case UNMODIFIED: {
                LOG.debug("Modification {} unmodified path {}", (Object)modification, (Object)path);
                break;
            }
            case WRITE: {
                modification.write(path, node.getDataAfter().get());
                LOG.debug("Modification {} written path {}", (Object)modification, (Object)path);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported modification " + (Object)((Object)node.getModificationType()));
            }
        }
    }

    private static void applyToCursorAwareModification(CursorAwareDataTreeModification modification, DataTreeCandidate candidate) {
        YangInstanceIdentifier candidatePath = candidate.getRootPath();
        if (candidatePath.isEmpty()) {
            try (DataTreeModificationCursor cursor = modification.openCursor();){
                DataTreeCandidateNodes.applyRootToCursor(cursor, candidate.getRootNode());
            }
        }
        try (DataTreeModificationCursor cursor = modification.openCursor(candidatePath.getParent()).get();){
            DataTreeCandidateNodes.applyRootedNodeToCursor(cursor, candidatePath, candidate.getRootNode());
        }
    }

    private static final class NodeIterator {
        private final Iterator<DataTreeCandidateNode> iterator;
        private final YangInstanceIdentifier path;
        private final NodeIterator parent;

        NodeIterator(@Nullable NodeIterator parent, YangInstanceIdentifier path, Iterator<DataTreeCandidateNode> iterator) {
            this.iterator = Objects.requireNonNull(iterator);
            this.path = Objects.requireNonNull(path);
            this.parent = parent;
        }

        NodeIterator next(DataTreeModification modification) {
            block6: while (this.iterator.hasNext()) {
                DataTreeCandidateNode node = this.iterator.next();
                YangInstanceIdentifier child = this.path.node(node.getIdentifier());
                switch (node.getModificationType()) {
                    case DELETE: {
                        modification.delete(child);
                        LOG.debug("Modification {} deleted path {}", (Object)modification, (Object)child);
                        continue block6;
                    }
                    case SUBTREE_MODIFIED: 
                    case APPEARED: 
                    case DISAPPEARED: {
                        LOG.debug("Modification {} modified path {}", (Object)modification, (Object)child);
                        return new NodeIterator(this, child, node.getChildNodes().iterator());
                    }
                    case UNMODIFIED: {
                        LOG.debug("Modification {} unmodified path {}", (Object)modification, (Object)child);
                        continue block6;
                    }
                    case WRITE: {
                        modification.write(child, node.getDataAfter().get());
                        LOG.debug("Modification {} written path {}", (Object)modification, (Object)child);
                        continue block6;
                    }
                }
                throw new IllegalArgumentException("Unsupported modification " + (Object)((Object)node.getModificationType()));
            }
            return this.parent;
        }
    }
}

