/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.sdninterfaceapp.impl.sdniwrapper;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.opendaylight.sdninterfaceapp.impl.sdniwrapper.SdniMsgSynchronizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDNiServerListener
extends TimerTask {
    private static final Logger log = LoggerFactory.getLogger(SDNiServerListener.class);
    private static final int ClientPort = 8115;
    private static SDNiServerListener serverListener;
    private static SdniMsgSynchronizer sdniMsgSync;

    SDNiServerListener() {
        sdniMsgSync = SdniMsgSynchronizer.getInstance();
    }

    public static SDNiServerListener getInstance() {
        if (serverListener == null) {
            serverListener = new SDNiServerListener();
        }
        return serverListener;
    }

    public static void startListener() {
        ExecutorService executor = null;
        log.info("Listening on Port 8115");
        try {
            ServerSocket serverSocket = new ServerSocket(8115);
            Throwable throwable = null;
            try {
                try {
                    executor = Executors.newFixedThreadPool(sdniMsgSync.getPeerControllers().size());
                    log.info("Waiting for clients");
                    while (true) {
                        Socket clientSocket = serverSocket.accept();
                        Runnable worker = () -> {
                            try (BufferedReader in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));){
                                String inputLine;
                                log.info("Thread started with name:" + Thread.currentThread().getName());
                                while ((inputLine = in.readLine()) != null) {
                                    log.info("Received message from " + Thread.currentThread().getName() + " : " + inputLine);
                                    sdniMsgSync.parseSDNIQoSMessage(inputLine);
                                    sdniMsgSync.parseSDNITopoMessage(inputLine);
                                }
                            }
                            catch (IOException e) {
                                log.error("I/O exception: " + e);
                            }
                            catch (Exception ex) {
                                log.error("Exceprion in Thread Run. Exception : " + ex);
                            }
                        };
                        executor.execute(worker);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (serverSocket != null) {
                    if (throwable != null) {
                        try {
                            serverSocket.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        serverSocket.close();
                    }
                }
                throw throwable3;
            }
        }
        catch (Exception e) {
            log.error("Exception caught when trying to listen on port 8115 or listening for a connection: " + e.getMessage());
            return;
        }
    }

    @Override
    public void run() {
        SDNiServerListener.startListener();
    }
}

