/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.utils.mdsal.utils;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.DataObjectModification;
import org.opendaylight.mdsal.binding.api.DataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.api.DataTreeModification;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotifyingDataChangeListener
implements AutoCloseable,
DataTreeChangeListener<DataObject> {
    private static final Logger LOG = LoggerFactory.getLogger(NotifyingDataChangeListener.class);
    private static final int RETRY_WAIT = 100;
    private static final int MDSAL_TIMEOUT_OPERATIONAL = 10000;
    private static final int MDSAL_TIMEOUT_CONFIG = 1000;
    public static final int BIT_CREATE = 1;
    public static final int BIT_UPDATE = 2;
    public static final int BIT_DELETE = 4;
    public static final int BIT_ALL = 7;
    private final Set<InstanceIdentifier<?>> createdIids = ConcurrentHashMap.newKeySet();
    private final Set<InstanceIdentifier<?>> removedIids = ConcurrentHashMap.newKeySet();
    private final Set<InstanceIdentifier<?>> updatedIids = ConcurrentHashMap.newKeySet();
    private final List<NotifyingDataChangeListener> waitList;
    private ListenerRegistration<?> listenerRegistration;
    private int mdsalTimeout = 10000;
    private volatile InstanceIdentifier<?> iid;
    private volatile LogicalDatastoreType type;
    private volatile boolean listen;
    private volatile int mask;

    public NotifyingDataChangeListener(LogicalDatastoreType type, int mask, InstanceIdentifier<?> iid, List<NotifyingDataChangeListener> waitList) {
        this(type, iid, waitList);
        this.mask = mask;
    }

    public NotifyingDataChangeListener(LogicalDatastoreType type, InstanceIdentifier<?> iid, List<NotifyingDataChangeListener> waitList) {
        this.type = type;
        this.iid = iid;
        this.waitList = waitList;
        if (this.waitList != null) {
            this.waitList.add(this);
        }
        this.mdsalTimeout = 10000;
        if (type == LogicalDatastoreType.CONFIGURATION) {
            this.mdsalTimeout = 1000;
        }
        this.listen = true;
        this.mask = 7;
    }

    public void modify(LogicalDatastoreType newType, InstanceIdentifier<?> newIid) {
        this.close();
        this.clear();
        this.type = newType;
        this.iid = newIid;
    }

    public void setlisten(boolean value) {
        this.listen = value;
    }

    public void setMask(int mask) {
        this.mask = mask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"NN_NAKED_NOTIFY"})
    public void onDataTreeChanged(Collection<DataTreeModification<DataObject>> changes) {
        if (!this.listen) {
            return;
        }
        for (DataTreeModification<DataObject> change : changes) {
            DataObjectModification rootNode = change.getRootNode();
            InstanceIdentifier identifier = change.getRootPath().getRootIdentifier();
            switch (rootNode.getModificationType()) {
                case SUBTREE_MODIFIED: 
                case WRITE: {
                    if (rootNode.getDataBefore() == null) {
                        if ((this.mask & 1) != 1) break;
                        LOG.info("{} DataTreeChanged: created {}", (Object)this.type, (Object)identifier);
                        this.createdIids.add(identifier);
                        break;
                    }
                    if ((this.mask & 2) != 2) break;
                    LOG.info("{} DataTreeChanged: updated {}", (Object)this.type, (Object)identifier);
                    this.updatedIids.add(identifier);
                    break;
                }
                case DELETE: {
                    if ((this.mask & 4) != 4) break;
                    LOG.info("{} DataTreeChanged: removed {}", (Object)this.type, (Object)identifier);
                    this.removedIids.add(identifier);
                    break;
                }
            }
        }
        NotifyingDataChangeListener notifyingDataChangeListener = this;
        synchronized (notifyingDataChangeListener) {
            this.notifyAll();
        }
    }

    public boolean isCreated(InstanceIdentifier<?> path) {
        return this.createdIids.remove(path);
    }

    public boolean isUpdated(InstanceIdentifier<?> path) {
        return this.updatedIids.remove(path);
    }

    public boolean isRemoved(InstanceIdentifier<?> path) {
        return this.removedIids.remove(path);
    }

    public void clear() {
        this.createdIids.clear();
        this.updatedIids.clear();
        this.removedIids.clear();
    }

    public void registerDataChangeListener(DataBroker dataBroker) {
        this.listenerRegistration = dataBroker.registerDataTreeChangeListener(DataTreeIdentifier.create((LogicalDatastoreType)this.type, this.iid), (DataTreeChangeListener)this);
    }

    public void waitForCreation() throws InterruptedException {
        this.waitForCreation(this.mdsalTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForCreation(long timeout) throws InterruptedException {
        NotifyingDataChangeListener notifyingDataChangeListener = this;
        synchronized (notifyingDataChangeListener) {
            long start = System.currentTimeMillis();
            LOG.info("Waiting for {} DataChanged creation on {}", (Object)this.type, this.iid);
            while (!this.isCreated(this.iid) && System.currentTimeMillis() - start < timeout) {
                this.wait(100L);
            }
            LOG.info("Woke up, waited {}ms for creation of {}", (Object)(System.currentTimeMillis() - start), this.iid);
        }
    }

    public void waitForUpdate() throws InterruptedException {
        this.waitForUpdate(this.mdsalTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForUpdate(long timeout) throws InterruptedException {
        NotifyingDataChangeListener notifyingDataChangeListener = this;
        synchronized (notifyingDataChangeListener) {
            long start = System.currentTimeMillis();
            LOG.info("Waiting for {} DataChanged update on {}", (Object)this.type, this.iid);
            while (!this.isUpdated(this.iid) && System.currentTimeMillis() - start < timeout) {
                this.wait(100L);
            }
            LOG.info("Woke up, waited {}ms for update of {}", (Object)(System.currentTimeMillis() - start), this.iid);
        }
    }

    public void waitForDeletion() throws InterruptedException {
        this.waitForDeletion(this.mdsalTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForDeletion(long timeout) throws InterruptedException {
        NotifyingDataChangeListener notifyingDataChangeListener = this;
        synchronized (notifyingDataChangeListener) {
            long start = System.currentTimeMillis();
            LOG.info("Waiting for {} DataChanged deletion on {}", (Object)this.type, this.iid);
            while (!this.isRemoved(this.iid) && System.currentTimeMillis() - start < timeout) {
                this.wait(100L);
            }
            LOG.info("Woke up, waited {}ms for deletion of {}", (Object)(System.currentTimeMillis() - start), this.iid);
        }
    }

    @Override
    public void close() {
        if (this.listenerRegistration != null) {
            this.listenerRegistration.close();
        }
        if (this.waitList != null) {
            this.waitList.remove(this);
        }
        this.listenerRegistration = null;
    }
}

