/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.utils.mdsal.utils;

import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Optional;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.ReadTransaction;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MdsalUtilsAsync {
    private static final Logger LOG = LoggerFactory.getLogger(MdsalUtilsAsync.class);
    private final DataBroker databroker;

    public MdsalUtilsAsync(DataBroker dataBroker) {
        this.databroker = dataBroker;
    }

    public <D extends DataObject> FluentFuture<? extends CommitInfo> delete(LogicalDatastoreType store, InstanceIdentifier<D> path) {
        WriteTransaction transaction = this.databroker.newWriteOnlyTransaction();
        transaction.delete(store, path);
        return transaction.commit();
    }

    public <D extends DataObject> void delete(LogicalDatastoreType store, InstanceIdentifier<D> path, String operationDesc) {
        this.assignDefaultCallback(this.delete(store, path), operationDesc);
    }

    public <D extends DataObject> FluentFuture<? extends CommitInfo> put(LogicalDatastoreType logicalDatastoreType, InstanceIdentifier<D> path, D data) {
        WriteTransaction transaction = this.databroker.newWriteOnlyTransaction();
        transaction.mergeParentStructurePut(logicalDatastoreType, path, data);
        return transaction.commit();
    }

    public <D extends DataObject> void put(LogicalDatastoreType logicalDatastoreType, InstanceIdentifier<D> path, D data, String operationDesc) {
        this.assignDefaultCallback(this.put(logicalDatastoreType, path, data), operationDesc);
    }

    public <D extends DataObject> FluentFuture<? extends CommitInfo> merge(LogicalDatastoreType logicalDatastoreType, InstanceIdentifier<D> path, D data, boolean withParent) {
        WriteTransaction transaction = this.databroker.newWriteOnlyTransaction();
        if (withParent) {
            transaction.mergeParentStructureMerge(logicalDatastoreType, path, data);
        } else {
            transaction.merge(logicalDatastoreType, path, data);
        }
        return transaction.commit();
    }

    public <D extends DataObject> void merge(LogicalDatastoreType logicalDatastoreType, InstanceIdentifier<D> path, D data, String operationDesc, boolean withParent) {
        this.assignDefaultCallback(this.merge(logicalDatastoreType, path, data, withParent), operationDesc);
    }

    public <D extends DataObject> FluentFuture<Optional<D>> read(LogicalDatastoreType store, InstanceIdentifier<D> path) {
        final ReadTransaction transaction = this.databroker.newReadOnlyTransaction();
        FluentFuture future = transaction.read(store, path);
        FutureCallback closeTransactionCallback = new FutureCallback<Optional<D>>(){

            public void onSuccess(Optional<D> result) {
                transaction.close();
            }

            public void onFailure(Throwable ex) {
                transaction.close();
            }
        };
        future.addCallback(closeTransactionCallback, MoreExecutors.directExecutor());
        return future;
    }

    void assignDefaultCallback(FluentFuture<? extends CommitInfo> transactionFuture, final String operationDesc) {
        transactionFuture.addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                LOG.debug("Transaction({}) SUCCESSFUL", (Object)operationDesc);
            }

            public void onFailure(Throwable ex) {
                LOG.error("Transaction({}) FAILED!", (Object)operationDesc, (Object)ex);
                throw new IllegalStateException("  Transaction(" + operationDesc + ") not committed correctly", ex);
            }
        }, MoreExecutors.directExecutor());
    }
}

