/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.utils.mdsal.utils;

import com.google.common.util.concurrent.FluentFuture;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.ReadTransaction;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MdsalUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MdsalUtils.class);
    private static int MDSAL_MAX_READ_TRIALS = Integer.getInteger("mdsalutil.max.tries", 30);
    private static int MDSAL_READ_SLEEP_INTERVAL_MS = Integer.getInteger("mdsalutil.sleep.between.mdsal.reads", 1000);
    private final DataBroker databroker;

    public MdsalUtils(DataBroker dataBroker) {
        this.databroker = dataBroker;
    }

    public <D extends DataObject> boolean delete(LogicalDatastoreType store, InstanceIdentifier<D> path) {
        boolean result = false;
        WriteTransaction transaction = this.databroker.newWriteOnlyTransaction();
        transaction.delete(store, path);
        FluentFuture future = transaction.commit();
        try {
            future.get();
            result = true;
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn("Failed to delete {} ", path, (Object)e);
        }
        return result;
    }

    public <D extends DataObject> boolean merge(LogicalDatastoreType logicalDatastoreType, InstanceIdentifier<D> path, D data) {
        boolean result = false;
        WriteTransaction transaction = this.databroker.newWriteOnlyTransaction();
        transaction.mergeParentStructureMerge(logicalDatastoreType, path, data);
        FluentFuture future = transaction.commit();
        try {
            future.get();
            result = true;
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn("Failed to merge {} ", path, (Object)e);
        }
        return result;
    }

    public <D extends DataObject> boolean put(LogicalDatastoreType logicalDatastoreType, InstanceIdentifier<D> path, D data) {
        boolean result = false;
        WriteTransaction transaction = this.databroker.newWriteOnlyTransaction();
        transaction.mergeParentStructurePut(logicalDatastoreType, path, data);
        FluentFuture future = transaction.commit();
        try {
            future.get();
            result = true;
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn("Failed to put {} ", path, (Object)e);
        }
        return result;
    }

    public <D extends DataObject> D read(LogicalDatastoreType store, InstanceIdentifier<? extends DataObject> path) {
        Optional<D> optionalDataObject = this.readOptional(store, path);
        if (optionalDataObject.isPresent()) {
            return (D)((DataObject)optionalDataObject.get());
        }
        LOG.debug("{}: Failed to read {}", (Object)Thread.currentThread().getStackTrace()[1], path);
        return null;
    }

    public <D extends DataObject> Optional<D> readOptional(LogicalDatastoreType store, InstanceIdentifier<? extends DataObject> path) {
        int trialNo = 0;
        ReadTransaction transaction = this.databroker.newReadOnlyTransaction();
        while (true) {
            try {
                Optional result = (Optional)transaction.read(store, path).get();
                transaction.close();
                return result;
            }
            catch (InterruptedException | ExecutionException e) {
                if (trialNo == 0) {
                    this.logReadFailureError(path, " mdsal Read failed exception retrying the read after sleep");
                }
                try {
                    transaction.close();
                    Thread.sleep(MDSAL_READ_SLEEP_INTERVAL_MS);
                    transaction = this.databroker.newReadOnlyTransaction();
                    continue;
                }
                catch (InterruptedException e1) {
                    this.logReadFailureError(path, " Sleep interrupted");
                }
                if (trialNo++ < MDSAL_MAX_READ_TRIALS) continue;
                this.logReadFailureError(path, " All read trials exceeded");
                return Optional.empty();
            }
            break;
        }
    }

    public boolean exists(LogicalDatastoreType store, InstanceIdentifier<? extends DataObject> path) {
        int trialNo = 0;
        ReadTransaction transaction = this.databroker.newReadOnlyTransaction();
        while (true) {
            try {
                FluentFuture result = transaction.exists(store, path);
                transaction.close();
                return (Boolean)result.get();
            }
            catch (InterruptedException | ExecutionException e) {
                if (trialNo == 0) {
                    this.logReadFailureError(path, " mdsal Read failed exception retrying the read after sleep");
                }
                try {
                    transaction.close();
                    Thread.sleep(MDSAL_READ_SLEEP_INTERVAL_MS);
                    transaction = this.databroker.newReadOnlyTransaction();
                    continue;
                }
                catch (InterruptedException e1) {
                    this.logReadFailureError(path, " Sleep interrupted");
                }
                if (trialNo++ < MDSAL_MAX_READ_TRIALS) continue;
                this.logReadFailureError(path, " All read trials exceeded");
                return false;
            }
            break;
        }
    }

    private <D extends DataObject> void logReadFailureError(InstanceIdentifier<D> path, String cause) {
        LOG.error("{}: Failed to read {} Cause : {}", new Object[]{Thread.currentThread().getStackTrace()[2], path, cause});
    }
}

