/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.ofj.nxm.of.match.eth.type.grouping;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.ofj.nxm.of.match.eth.type.grouping.EthTypeValues;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class EthTypeValuesBuilder
implements Builder<EthTypeValues> {
    private Integer _value;
    Map<Class<? extends Augmentation<EthTypeValues>>, Augmentation<EthTypeValues>> augmentation = Collections.emptyMap();

    public EthTypeValuesBuilder() {
    }

    public EthTypeValuesBuilder(EthTypeValues base) {
        AugmentationHolder casted;
        this._value = base.getValue();
        if (base instanceof EthTypeValuesImpl) {
            EthTypeValuesImpl impl = (EthTypeValuesImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<EthTypeValues>>, Augmentation<EthTypeValues>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<EthTypeValues>>, Augmentation<EthTypeValues>>(casted.augmentations());
        }
    }

    public Integer getValue() {
        return this._value;
    }

    public <E extends Augmentation<EthTypeValues>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkValueRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public EthTypeValuesBuilder setValue(Integer value) {
        if (value != null) {
            EthTypeValuesBuilder.checkValueRange(value);
        }
        this._value = value;
        return this;
    }

    public EthTypeValuesBuilder addAugmentation(Class<? extends Augmentation<EthTypeValues>> augmentationType, Augmentation<EthTypeValues> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<EthTypeValues>>, Augmentation<EthTypeValues>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public EthTypeValuesBuilder removeAugmentation(Class<? extends Augmentation<EthTypeValues>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public EthTypeValues build() {
        return new EthTypeValuesImpl(this);
    }

    private static final class EthTypeValuesImpl
    implements EthTypeValues {
        private final Integer _value;
        private Map<Class<? extends Augmentation<EthTypeValues>>, Augmentation<EthTypeValues>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<EthTypeValues> getImplementedInterface() {
            return EthTypeValues.class;
        }

        private EthTypeValuesImpl(EthTypeValuesBuilder base) {
            this._value = base.getValue();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<EthTypeValues>>, Augmentation<EthTypeValues>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<EthTypeValues>>, Augmentation<EthTypeValues>>(base.augmentation);
                }
            }
        }

        @Override
        public Integer getValue() {
            return this._value;
        }

        public <E extends Augmentation<EthTypeValues>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._value);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!EthTypeValues.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            EthTypeValues other = (EthTypeValues)obj;
            if (!Objects.equals(this._value, other.getValue())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                EthTypeValuesImpl otherImpl = (EthTypeValuesImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<EthTypeValues>>, Augmentation<EthTypeValues>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("EthTypeValues [");
            boolean first = true;
            if (this._value != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_value=");
                builder.append(this._value);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

