/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.ofj.nxm.of.match.arp.spa.grouping;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.ofj.nxm.of.match.arp.spa.grouping.ArpSpaValues;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ArpSpaValuesBuilder
implements Builder<ArpSpaValues> {
    private Long _value;
    Map<Class<? extends Augmentation<ArpSpaValues>>, Augmentation<ArpSpaValues>> augmentation = Collections.emptyMap();

    public ArpSpaValuesBuilder() {
    }

    public ArpSpaValuesBuilder(ArpSpaValues base) {
        AugmentationHolder casted;
        this._value = base.getValue();
        if (base instanceof ArpSpaValuesImpl) {
            ArpSpaValuesImpl impl = (ArpSpaValuesImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ArpSpaValues>>, Augmentation<ArpSpaValues>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ArpSpaValues>>, Augmentation<ArpSpaValues>>(casted.augmentations());
        }
    }

    public Long getValue() {
        return this._value;
    }

    public <E extends Augmentation<ArpSpaValues>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkValueRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public ArpSpaValuesBuilder setValue(Long value) {
        if (value != null) {
            ArpSpaValuesBuilder.checkValueRange(value);
        }
        this._value = value;
        return this;
    }

    public ArpSpaValuesBuilder addAugmentation(Class<? extends Augmentation<ArpSpaValues>> augmentationType, Augmentation<ArpSpaValues> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ArpSpaValues>>, Augmentation<ArpSpaValues>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ArpSpaValuesBuilder removeAugmentation(Class<? extends Augmentation<ArpSpaValues>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ArpSpaValues build() {
        return new ArpSpaValuesImpl(this);
    }

    private static final class ArpSpaValuesImpl
    implements ArpSpaValues {
        private final Long _value;
        private Map<Class<? extends Augmentation<ArpSpaValues>>, Augmentation<ArpSpaValues>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ArpSpaValues> getImplementedInterface() {
            return ArpSpaValues.class;
        }

        private ArpSpaValuesImpl(ArpSpaValuesBuilder base) {
            this._value = base.getValue();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ArpSpaValues>>, Augmentation<ArpSpaValues>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ArpSpaValues>>, Augmentation<ArpSpaValues>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getValue() {
            return this._value;
        }

        public <E extends Augmentation<ArpSpaValues>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._value);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ArpSpaValues.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ArpSpaValues other = (ArpSpaValues)obj;
            if (!Objects.equals(this._value, other.getValue())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ArpSpaValuesImpl otherImpl = (ArpSpaValuesImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ArpSpaValues>>, Augmentation<ArpSpaValues>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("ArpSpaValues [");
            boolean first = true;
            if (this._value != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_value=");
                builder.append(this._value);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

