/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.ofj.nxm.nx.match.nsi.grouping;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.ofj.nxm.nx.match.nsi.grouping.NsiValues;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NsiValuesBuilder
implements Builder<NsiValues> {
    private Short _nsi;
    Map<Class<? extends Augmentation<NsiValues>>, Augmentation<NsiValues>> augmentation = Collections.emptyMap();

    public NsiValuesBuilder() {
    }

    public NsiValuesBuilder(NsiValues base) {
        AugmentationHolder casted;
        this._nsi = base.getNsi();
        if (base instanceof NsiValuesImpl) {
            NsiValuesImpl impl = (NsiValuesImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<NsiValues>>, Augmentation<NsiValues>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NsiValues>>, Augmentation<NsiValues>>(casted.augmentations());
        }
    }

    public Short getNsi() {
        return this._nsi;
    }

    public <E extends Augmentation<NsiValues>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkNsiRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public NsiValuesBuilder setNsi(Short value) {
        if (value != null) {
            NsiValuesBuilder.checkNsiRange(value);
        }
        this._nsi = value;
        return this;
    }

    public NsiValuesBuilder addAugmentation(Class<? extends Augmentation<NsiValues>> augmentationType, Augmentation<NsiValues> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NsiValues>>, Augmentation<NsiValues>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public NsiValuesBuilder removeAugmentation(Class<? extends Augmentation<NsiValues>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NsiValues build() {
        return new NsiValuesImpl(this);
    }

    private static final class NsiValuesImpl
    implements NsiValues {
        private final Short _nsi;
        private Map<Class<? extends Augmentation<NsiValues>>, Augmentation<NsiValues>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<NsiValues> getImplementedInterface() {
            return NsiValues.class;
        }

        private NsiValuesImpl(NsiValuesBuilder base) {
            this._nsi = base.getNsi();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<NsiValues>>, Augmentation<NsiValues>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<NsiValues>>, Augmentation<NsiValues>>(base.augmentation);
                }
            }
        }

        @Override
        public Short getNsi() {
            return this._nsi;
        }

        public <E extends Augmentation<NsiValues>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._nsi);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NsiValues.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NsiValues other = (NsiValues)obj;
            if (!Objects.equals(this._nsi, other.getNsi())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NsiValuesImpl otherImpl = (NsiValuesImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<NsiValues>>, Augmentation<NsiValues>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("NsiValues [");
            boolean first = true;
            if (this._nsi != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nsi=");
                builder.append(this._nsi);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

