/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofj.nx.action.reg.move.grouping;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.ExperimenterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofj.nx.action.reg.move.grouping.NxActionRegMove;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NxActionRegMoveBuilder
implements Builder<NxActionRegMove> {
    private Long _dst;
    private Integer _dstOfs;
    private ExperimenterId _experimenterId;
    private Integer _nBits;
    private Long _src;
    private Integer _srcOfs;
    Map<Class<? extends Augmentation<NxActionRegMove>>, Augmentation<NxActionRegMove>> augmentation = Collections.emptyMap();

    public NxActionRegMoveBuilder() {
    }

    public NxActionRegMoveBuilder(NxActionRegMove base) {
        AugmentationHolder casted;
        this._dst = base.getDst();
        this._dstOfs = base.getDstOfs();
        this._experimenterId = base.getExperimenterId();
        this._nBits = base.getNBits();
        this._src = base.getSrc();
        this._srcOfs = base.getSrcOfs();
        if (base instanceof NxActionRegMoveImpl) {
            NxActionRegMoveImpl impl = (NxActionRegMoveImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<NxActionRegMove>>, Augmentation<NxActionRegMove>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxActionRegMove>>, Augmentation<NxActionRegMove>>(casted.augmentations());
        }
    }

    public Long getDst() {
        return this._dst;
    }

    public Integer getDstOfs() {
        return this._dstOfs;
    }

    public ExperimenterId getExperimenterId() {
        return this._experimenterId;
    }

    public Integer getNBits() {
        return this._nBits;
    }

    public Long getSrc() {
        return this._src;
    }

    public Integer getSrcOfs() {
        return this._srcOfs;
    }

    public <E extends Augmentation<NxActionRegMove>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkDstRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public NxActionRegMoveBuilder setDst(Long value) {
        if (value != null) {
            NxActionRegMoveBuilder.checkDstRange(value);
        }
        this._dst = value;
        return this;
    }

    private static void checkDstOfsRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public NxActionRegMoveBuilder setDstOfs(Integer value) {
        if (value != null) {
            NxActionRegMoveBuilder.checkDstOfsRange(value);
        }
        this._dstOfs = value;
        return this;
    }

    public NxActionRegMoveBuilder setExperimenterId(ExperimenterId value) {
        this._experimenterId = value;
        return this;
    }

    private static void checkNBitsRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public NxActionRegMoveBuilder setNBits(Integer value) {
        if (value != null) {
            NxActionRegMoveBuilder.checkNBitsRange(value);
        }
        this._nBits = value;
        return this;
    }

    private static void checkSrcRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public NxActionRegMoveBuilder setSrc(Long value) {
        if (value != null) {
            NxActionRegMoveBuilder.checkSrcRange(value);
        }
        this._src = value;
        return this;
    }

    private static void checkSrcOfsRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public NxActionRegMoveBuilder setSrcOfs(Integer value) {
        if (value != null) {
            NxActionRegMoveBuilder.checkSrcOfsRange(value);
        }
        this._srcOfs = value;
        return this;
    }

    public NxActionRegMoveBuilder addAugmentation(Class<? extends Augmentation<NxActionRegMove>> augmentationType, Augmentation<NxActionRegMove> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxActionRegMove>>, Augmentation<NxActionRegMove>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public NxActionRegMoveBuilder removeAugmentation(Class<? extends Augmentation<NxActionRegMove>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NxActionRegMove build() {
        return new NxActionRegMoveImpl(this);
    }

    private static final class NxActionRegMoveImpl
    implements NxActionRegMove {
        private final Long _dst;
        private final Integer _dstOfs;
        private final ExperimenterId _experimenterId;
        private final Integer _nBits;
        private final Long _src;
        private final Integer _srcOfs;
        private Map<Class<? extends Augmentation<NxActionRegMove>>, Augmentation<NxActionRegMove>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<NxActionRegMove> getImplementedInterface() {
            return NxActionRegMove.class;
        }

        private NxActionRegMoveImpl(NxActionRegMoveBuilder base) {
            this._dst = base.getDst();
            this._dstOfs = base.getDstOfs();
            this._experimenterId = base.getExperimenterId();
            this._nBits = base.getNBits();
            this._src = base.getSrc();
            this._srcOfs = base.getSrcOfs();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<NxActionRegMove>>, Augmentation<NxActionRegMove>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<NxActionRegMove>>, Augmentation<NxActionRegMove>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getDst() {
            return this._dst;
        }

        @Override
        public Integer getDstOfs() {
            return this._dstOfs;
        }

        @Override
        public ExperimenterId getExperimenterId() {
            return this._experimenterId;
        }

        @Override
        public Integer getNBits() {
            return this._nBits;
        }

        @Override
        public Long getSrc() {
            return this._src;
        }

        @Override
        public Integer getSrcOfs() {
            return this._srcOfs;
        }

        public <E extends Augmentation<NxActionRegMove>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._dst);
            result = 31 * result + Objects.hashCode(this._dstOfs);
            result = 31 * result + Objects.hashCode(this._experimenterId);
            result = 31 * result + Objects.hashCode(this._nBits);
            result = 31 * result + Objects.hashCode(this._src);
            result = 31 * result + Objects.hashCode(this._srcOfs);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionRegMove.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionRegMove other = (NxActionRegMove)obj;
            if (!Objects.equals(this._dst, other.getDst())) {
                return false;
            }
            if (!Objects.equals(this._dstOfs, other.getDstOfs())) {
                return false;
            }
            if (!Objects.equals(this._experimenterId, other.getExperimenterId())) {
                return false;
            }
            if (!Objects.equals(this._nBits, other.getNBits())) {
                return false;
            }
            if (!Objects.equals(this._src, other.getSrc())) {
                return false;
            }
            if (!Objects.equals(this._srcOfs, other.getSrcOfs())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NxActionRegMoveImpl otherImpl = (NxActionRegMoveImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<NxActionRegMove>>, Augmentation<NxActionRegMove>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("NxActionRegMove [");
            boolean first = true;
            if (this._dst != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_dst=");
                builder.append(this._dst);
            }
            if (this._dstOfs != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_dstOfs=");
                builder.append(this._dstOfs);
            }
            if (this._experimenterId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_experimenterId=");
                builder.append(this._experimenterId);
            }
            if (this._nBits != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nBits=");
                builder.append(this._nBits);
            }
            if (this._src != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_src=");
                builder.append(this._src);
            }
            if (this._srcOfs != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_srcOfs=");
                builder.append(this._srcOfs);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

