/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofj.nx.action.reg.load.grouping;

import com.google.common.collect.Range;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.ExperimenterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofj.nx.action.reg.load.grouping.NxActionRegLoad;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NxActionRegLoadBuilder
implements Builder<NxActionRegLoad> {
    private Long _dst;
    private ExperimenterId _experimenterId;
    private Integer _ofsNbits;
    private BigInteger _value;
    Map<Class<? extends Augmentation<NxActionRegLoad>>, Augmentation<NxActionRegLoad>> augmentation = Collections.emptyMap();
    private static final Range<BigInteger>[] CHECKVALUERANGE_RANGES;

    public NxActionRegLoadBuilder() {
    }

    public NxActionRegLoadBuilder(NxActionRegLoad base) {
        AugmentationHolder casted;
        this._dst = base.getDst();
        this._experimenterId = base.getExperimenterId();
        this._ofsNbits = base.getOfsNbits();
        this._value = base.getValue();
        if (base instanceof NxActionRegLoadImpl) {
            NxActionRegLoadImpl impl = (NxActionRegLoadImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<NxActionRegLoad>>, Augmentation<NxActionRegLoad>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxActionRegLoad>>, Augmentation<NxActionRegLoad>>(casted.augmentations());
        }
    }

    public Long getDst() {
        return this._dst;
    }

    public ExperimenterId getExperimenterId() {
        return this._experimenterId;
    }

    public Integer getOfsNbits() {
        return this._ofsNbits;
    }

    public BigInteger getValue() {
        return this._value;
    }

    public <E extends Augmentation<NxActionRegLoad>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkDstRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public NxActionRegLoadBuilder setDst(Long value) {
        if (value != null) {
            NxActionRegLoadBuilder.checkDstRange(value);
        }
        this._dst = value;
        return this;
    }

    public NxActionRegLoadBuilder setExperimenterId(ExperimenterId value) {
        this._experimenterId = value;
        return this;
    }

    private static void checkOfsNbitsRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public NxActionRegLoadBuilder setOfsNbits(Integer value) {
        if (value != null) {
            NxActionRegLoadBuilder.checkOfsNbitsRange(value);
        }
        this._ofsNbits = value;
        return this;
    }

    private static void checkValueRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKVALUERANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKVALUERANGE_RANGES)));
    }

    public NxActionRegLoadBuilder setValue(BigInteger value) {
        if (value != null) {
            NxActionRegLoadBuilder.checkValueRange(value);
        }
        this._value = value;
        return this;
    }

    public NxActionRegLoadBuilder addAugmentation(Class<? extends Augmentation<NxActionRegLoad>> augmentationType, Augmentation<NxActionRegLoad> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxActionRegLoad>>, Augmentation<NxActionRegLoad>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public NxActionRegLoadBuilder removeAugmentation(Class<? extends Augmentation<NxActionRegLoad>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NxActionRegLoad build() {
        return new NxActionRegLoadImpl(this);
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKVALUERANGE_RANGES = a;
    }

    private static final class NxActionRegLoadImpl
    implements NxActionRegLoad {
        private final Long _dst;
        private final ExperimenterId _experimenterId;
        private final Integer _ofsNbits;
        private final BigInteger _value;
        private Map<Class<? extends Augmentation<NxActionRegLoad>>, Augmentation<NxActionRegLoad>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<NxActionRegLoad> getImplementedInterface() {
            return NxActionRegLoad.class;
        }

        private NxActionRegLoadImpl(NxActionRegLoadBuilder base) {
            this._dst = base.getDst();
            this._experimenterId = base.getExperimenterId();
            this._ofsNbits = base.getOfsNbits();
            this._value = base.getValue();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<NxActionRegLoad>>, Augmentation<NxActionRegLoad>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<NxActionRegLoad>>, Augmentation<NxActionRegLoad>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getDst() {
            return this._dst;
        }

        @Override
        public ExperimenterId getExperimenterId() {
            return this._experimenterId;
        }

        @Override
        public Integer getOfsNbits() {
            return this._ofsNbits;
        }

        @Override
        public BigInteger getValue() {
            return this._value;
        }

        public <E extends Augmentation<NxActionRegLoad>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._dst);
            result = 31 * result + Objects.hashCode(this._experimenterId);
            result = 31 * result + Objects.hashCode(this._ofsNbits);
            result = 31 * result + Objects.hashCode(this._value);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionRegLoad.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionRegLoad other = (NxActionRegLoad)obj;
            if (!Objects.equals(this._dst, other.getDst())) {
                return false;
            }
            if (!Objects.equals(this._experimenterId, other.getExperimenterId())) {
                return false;
            }
            if (!Objects.equals(this._ofsNbits, other.getOfsNbits())) {
                return false;
            }
            if (!Objects.equals(this._value, other.getValue())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NxActionRegLoadImpl otherImpl = (NxActionRegLoadImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<NxActionRegLoad>>, Augmentation<NxActionRegLoad>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("NxActionRegLoad [");
            boolean first = true;
            if (this._dst != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_dst=");
                builder.append(this._dst);
            }
            if (this._experimenterId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_experimenterId=");
                builder.append(this._experimenterId);
            }
            if (this._ofsNbits != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ofsNbits=");
                builder.append(this._ofsNbits);
            }
            if (this._value != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_value=");
                builder.append(this._value);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

