/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofj.nx.action.conntrack.grouping;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.ExperimenterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofj.nx.action.conntrack.grouping.NxActionConntrack;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NxActionConntrackBuilder
implements Builder<NxActionConntrack> {
    private Integer _conntrackZone;
    private ExperimenterId _experimenterId;
    private Integer _flags;
    private Short _recircTable;
    private Long _zoneSrc;
    Map<Class<? extends Augmentation<NxActionConntrack>>, Augmentation<NxActionConntrack>> augmentation = Collections.emptyMap();

    public NxActionConntrackBuilder() {
    }

    public NxActionConntrackBuilder(NxActionConntrack base) {
        AugmentationHolder casted;
        this._conntrackZone = base.getConntrackZone();
        this._experimenterId = base.getExperimenterId();
        this._flags = base.getFlags();
        this._recircTable = base.getRecircTable();
        this._zoneSrc = base.getZoneSrc();
        if (base instanceof NxActionConntrackImpl) {
            NxActionConntrackImpl impl = (NxActionConntrackImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<NxActionConntrack>>, Augmentation<NxActionConntrack>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxActionConntrack>>, Augmentation<NxActionConntrack>>(casted.augmentations());
        }
    }

    public Integer getConntrackZone() {
        return this._conntrackZone;
    }

    public ExperimenterId getExperimenterId() {
        return this._experimenterId;
    }

    public Integer getFlags() {
        return this._flags;
    }

    public Short getRecircTable() {
        return this._recircTable;
    }

    public Long getZoneSrc() {
        return this._zoneSrc;
    }

    public <E extends Augmentation<NxActionConntrack>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkConntrackZoneRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public NxActionConntrackBuilder setConntrackZone(Integer value) {
        if (value != null) {
            NxActionConntrackBuilder.checkConntrackZoneRange(value);
        }
        this._conntrackZone = value;
        return this;
    }

    public NxActionConntrackBuilder setExperimenterId(ExperimenterId value) {
        this._experimenterId = value;
        return this;
    }

    private static void checkFlagsRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public NxActionConntrackBuilder setFlags(Integer value) {
        if (value != null) {
            NxActionConntrackBuilder.checkFlagsRange(value);
        }
        this._flags = value;
        return this;
    }

    private static void checkRecircTableRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public NxActionConntrackBuilder setRecircTable(Short value) {
        if (value != null) {
            NxActionConntrackBuilder.checkRecircTableRange(value);
        }
        this._recircTable = value;
        return this;
    }

    private static void checkZoneSrcRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public NxActionConntrackBuilder setZoneSrc(Long value) {
        if (value != null) {
            NxActionConntrackBuilder.checkZoneSrcRange(value);
        }
        this._zoneSrc = value;
        return this;
    }

    public NxActionConntrackBuilder addAugmentation(Class<? extends Augmentation<NxActionConntrack>> augmentationType, Augmentation<NxActionConntrack> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxActionConntrack>>, Augmentation<NxActionConntrack>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public NxActionConntrackBuilder removeAugmentation(Class<? extends Augmentation<NxActionConntrack>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NxActionConntrack build() {
        return new NxActionConntrackImpl(this);
    }

    private static final class NxActionConntrackImpl
    implements NxActionConntrack {
        private final Integer _conntrackZone;
        private final ExperimenterId _experimenterId;
        private final Integer _flags;
        private final Short _recircTable;
        private final Long _zoneSrc;
        private Map<Class<? extends Augmentation<NxActionConntrack>>, Augmentation<NxActionConntrack>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<NxActionConntrack> getImplementedInterface() {
            return NxActionConntrack.class;
        }

        private NxActionConntrackImpl(NxActionConntrackBuilder base) {
            this._conntrackZone = base.getConntrackZone();
            this._experimenterId = base.getExperimenterId();
            this._flags = base.getFlags();
            this._recircTable = base.getRecircTable();
            this._zoneSrc = base.getZoneSrc();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<NxActionConntrack>>, Augmentation<NxActionConntrack>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<NxActionConntrack>>, Augmentation<NxActionConntrack>>(base.augmentation);
                }
            }
        }

        @Override
        public Integer getConntrackZone() {
            return this._conntrackZone;
        }

        @Override
        public ExperimenterId getExperimenterId() {
            return this._experimenterId;
        }

        @Override
        public Integer getFlags() {
            return this._flags;
        }

        @Override
        public Short getRecircTable() {
            return this._recircTable;
        }

        @Override
        public Long getZoneSrc() {
            return this._zoneSrc;
        }

        public <E extends Augmentation<NxActionConntrack>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._conntrackZone);
            result = 31 * result + Objects.hashCode(this._experimenterId);
            result = 31 * result + Objects.hashCode(this._flags);
            result = 31 * result + Objects.hashCode(this._recircTable);
            result = 31 * result + Objects.hashCode(this._zoneSrc);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionConntrack.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionConntrack other = (NxActionConntrack)obj;
            if (!Objects.equals(this._conntrackZone, other.getConntrackZone())) {
                return false;
            }
            if (!Objects.equals(this._experimenterId, other.getExperimenterId())) {
                return false;
            }
            if (!Objects.equals(this._flags, other.getFlags())) {
                return false;
            }
            if (!Objects.equals(this._recircTable, other.getRecircTable())) {
                return false;
            }
            if (!Objects.equals(this._zoneSrc, other.getZoneSrc())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NxActionConntrackImpl otherImpl = (NxActionConntrackImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<NxActionConntrack>>, Augmentation<NxActionConntrack>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("NxActionConntrack [");
            boolean first = true;
            if (this._conntrackZone != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_conntrackZone=");
                builder.append(this._conntrackZone);
            }
            if (this._experimenterId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_experimenterId=");
                builder.append(this._experimenterId);
            }
            if (this._flags != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_flags=");
                builder.append(this._flags);
            }
            if (this._recircTable != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_recircTable=");
                builder.append(this._recircTable);
            }
            if (this._zoneSrc != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_zoneSrc=");
                builder.append(this._zoneSrc);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

