/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.nx.codec.match;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.nx.codec.match.AbstractMatchCodec;
import org.opendaylight.openflowjava.protocol.api.keys.MatchEntryDeserializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.MatchEntrySerializerKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.MatchField;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Nxm0Class;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OxmClassBase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.MatchEntryValue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.NxmOfTcpDst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.ofj.nxm.of.match.tcp.dst.grouping.TcpDstValuesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.oxm.container.match.entry.value.TcpDstCaseValue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.oxm.container.match.entry.value.TcpDstCaseValueBuilder;

public class TcpDstCodec
extends AbstractMatchCodec {
    private static final int VALUE_LENGTH = 4;
    private static final int NXM_FIELD_CODE = 10;
    public static final MatchEntrySerializerKey<Nxm0Class, NxmOfTcpDst> SERIALIZER_KEY = new MatchEntrySerializerKey(4, Nxm0Class.class, NxmOfTcpDst.class);
    public static final MatchEntryDeserializerKey DESERIALIZER_KEY = new MatchEntryDeserializerKey(4, 0, 10);

    public void serialize(MatchEntry input, ByteBuf outBuffer) {
        this.serializeHeader(input, outBuffer);
        TcpDstCaseValue tcpDstCase = (TcpDstCaseValue)input.getMatchEntryValue();
        outBuffer.writeShort(tcpDstCase.getTcpDstValues().getPort().getValue().intValue());
        outBuffer.writeShort(tcpDstCase.getTcpDstValues().getMask().intValue());
    }

    public MatchEntry deserialize(ByteBuf message) {
        MatchEntryBuilder matchEntryBuilder = this.deserializeHeader(message);
        matchEntryBuilder.setHasMask(Boolean.valueOf(true));
        int portNo = message.readUnsignedShort();
        int mask = message.readUnsignedShort();
        message.readBytes(mask);
        TcpDstCaseValueBuilder caseBuilder = new TcpDstCaseValueBuilder();
        TcpDstValuesBuilder tcpDstValuesBuilder = new TcpDstValuesBuilder();
        tcpDstValuesBuilder.setPort(new PortNumber(Integer.valueOf(portNo)));
        tcpDstValuesBuilder.setMask(portNo);
        caseBuilder.setTcpDstValues(tcpDstValuesBuilder.build());
        matchEntryBuilder.setMatchEntryValue((MatchEntryValue)caseBuilder.build());
        return matchEntryBuilder.build();
    }

    @Override
    public int getNxmFieldCode() {
        return 10;
    }

    @Override
    public int getOxmClassCode() {
        return 0;
    }

    @Override
    public int getValueLength() {
        return 4;
    }

    @Override
    public Class<? extends MatchField> getNxmField() {
        return NxmOfTcpDst.class;
    }

    @Override
    public Class<? extends OxmClassBase> getOxmClass() {
        return Nxm0Class.class;
    }
}

