/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.nx.codec.match;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.nx.codec.match.AbstractMatchCodec;
import org.opendaylight.openflowjava.protocol.api.keys.MatchEntryDeserializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.MatchEntrySerializerKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.MatchField;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Nxm0Class;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OxmClassBase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.MatchEntryValue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.NxmOfIcmpType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.ofj.nxm.of.match.icmp.type.grouping.IcmpTypeValuesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.oxm.container.match.entry.value.IcmpTypeCaseValue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.oxm.container.match.entry.value.IcmpTypeCaseValueBuilder;

public class IcmpTypeCodec
extends AbstractMatchCodec {
    private static final int VALUE_LENGTH = 1;
    private static final int NXM_FIELD_CODE = 13;
    public static final MatchEntrySerializerKey<Nxm0Class, NxmOfIcmpType> SERIALIZER_KEY = new MatchEntrySerializerKey(4, Nxm0Class.class, NxmOfIcmpType.class);
    public static final MatchEntryDeserializerKey DESERIALIZER_KEY = new MatchEntryDeserializerKey(4, 0, 13);

    public MatchEntry deserialize(ByteBuf message) {
        MatchEntryBuilder matchEntriesBuilder = this.deserializeHeader(message);
        IcmpTypeCaseValueBuilder icmpTypeCaseValueBuilder = new IcmpTypeCaseValueBuilder();
        icmpTypeCaseValueBuilder.setIcmpTypeValues(new IcmpTypeValuesBuilder().setValue(message.readUnsignedByte()).build());
        matchEntriesBuilder.setMatchEntryValue((MatchEntryValue)icmpTypeCaseValueBuilder.build());
        matchEntriesBuilder.setHasMask(Boolean.valueOf(false));
        return matchEntriesBuilder.build();
    }

    public void serialize(MatchEntry input, ByteBuf outBuffer) {
        this.serializeHeader(input, outBuffer);
        IcmpTypeCaseValue icmpTypeValue = (IcmpTypeCaseValue)input.getMatchEntryValue();
        outBuffer.writeByte((int)icmpTypeValue.getIcmpTypeValues().getValue().shortValue());
    }

    @Override
    public int getNxmFieldCode() {
        return 13;
    }

    @Override
    public int getOxmClassCode() {
        return 0;
    }

    @Override
    public int getValueLength() {
        return 1;
    }

    @Override
    public Class<? extends MatchField> getNxmField() {
        return NxmOfIcmpType.class;
    }

    @Override
    public Class<? extends OxmClassBase> getOxmClass() {
        return Nxm0Class.class;
    }
}

