/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.nx.codec.match;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.nx.codec.match.AbstractMatchCodec;
import org.opendaylight.openflowjava.protocol.api.keys.MatchEntryDeserializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.MatchEntrySerializerKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.MatchField;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Nxm1Class;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OxmClassBase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.MatchEntryValue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.NxmNxCtZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.ofj.nxm.nx.match.ct.zone.grouping.CtZoneValuesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.oxm.container.match.entry.value.CtZoneCaseValue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.oxm.container.match.entry.value.CtZoneCaseValueBuilder;

public class CtZoneCodec
extends AbstractMatchCodec {
    private static final int VALUE_LENGTH = 2;
    private static final int NXM_FIELD_CODE = 106;
    public static final MatchEntrySerializerKey<Nxm1Class, NxmNxCtZone> SERIALIZER_KEY = new MatchEntrySerializerKey(4, Nxm1Class.class, NxmNxCtZone.class);
    public static final MatchEntryDeserializerKey DESERIALIZER_KEY = new MatchEntryDeserializerKey(4, 1, 106);

    public void serialize(MatchEntry input, ByteBuf outBuffer) {
        this.serializeHeader(input, outBuffer);
        CtZoneCaseValue ctZoneCase = (CtZoneCaseValue)input.getMatchEntryValue();
        outBuffer.writeShort(ctZoneCase.getCtZoneValues().getCtZone().intValue());
    }

    public MatchEntry deserialize(ByteBuf message) {
        MatchEntryBuilder matchEntryBuilder = this.deserializeHeader(message);
        CtZoneCaseValueBuilder caseBuilder = new CtZoneCaseValueBuilder();
        CtZoneValuesBuilder ctZoneValuesBuilder = new CtZoneValuesBuilder();
        ctZoneValuesBuilder.setCtZone(message.readUnsignedShort());
        caseBuilder.setCtZoneValues(ctZoneValuesBuilder.build());
        matchEntryBuilder.setMatchEntryValue((MatchEntryValue)caseBuilder.build());
        return matchEntryBuilder.build();
    }

    @Override
    public int getNxmFieldCode() {
        return 106;
    }

    @Override
    public int getOxmClassCode() {
        return 1;
    }

    @Override
    public int getValueLength() {
        return 2;
    }

    @Override
    public Class<? extends MatchField> getNxmField() {
        return NxmNxCtZone.class;
    }

    @Override
    public Class<? extends OxmClassBase> getOxmClass() {
        return Nxm1Class.class;
    }
}

