/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.nx.codec.match;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.nx.codec.match.AbstractMatchCodec;
import org.opendaylight.openflowjava.protocol.api.keys.MatchEntryDeserializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.MatchEntrySerializerKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.MatchField;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Nxm1Class;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OxmClassBase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.MatchEntryValue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.NxmNxCtState;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.ofj.nxm.nx.match.ct.state.grouping.CtStateValuesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.oxm.container.match.entry.value.CtStateCaseValue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.oxm.container.match.entry.value.CtStateCaseValueBuilder;

public class CtStateCodec
extends AbstractMatchCodec {
    private static final int VALUE_LENGTH = 8;
    private static final int NXM_FIELD_CODE = 105;
    public static final MatchEntrySerializerKey<Nxm1Class, NxmNxCtState> SERIALIZER_KEY = new MatchEntrySerializerKey(4, Nxm1Class.class, NxmNxCtState.class);
    public static final MatchEntryDeserializerKey DESERIALIZER_KEY = new MatchEntryDeserializerKey(4, 1, 105);

    public void serialize(MatchEntry input, ByteBuf outBuffer) {
        this.serializeHeader(input, outBuffer);
        CtStateCaseValue ctStateCase = (CtStateCaseValue)input.getMatchEntryValue();
        outBuffer.writeInt(ctStateCase.getCtStateValues().getCtState().intValue());
        outBuffer.writeInt(ctStateCase.getCtStateValues().getMask().intValue());
    }

    public MatchEntry deserialize(ByteBuf message) {
        MatchEntryBuilder matchEntryBuilder = this.deserializeHeader(message);
        CtStateCaseValueBuilder caseBuilder = new CtStateCaseValueBuilder();
        CtStateValuesBuilder ctStateValuesBuilder = new CtStateValuesBuilder();
        ctStateValuesBuilder.setCtState(message.readUnsignedInt());
        ctStateValuesBuilder.setMask(message.readUnsignedInt());
        caseBuilder.setCtStateValues(ctStateValuesBuilder.build());
        matchEntryBuilder.setMatchEntryValue((MatchEntryValue)caseBuilder.build());
        matchEntryBuilder.setHasMask(Boolean.valueOf(true));
        return matchEntryBuilder.build();
    }

    @Override
    public int getNxmFieldCode() {
        return 105;
    }

    @Override
    public int getOxmClassCode() {
        return 1;
    }

    @Override
    public int getValueLength() {
        return 8;
    }

    @Override
    public Class<? extends MatchField> getNxmField() {
        return NxmNxCtState.class;
    }

    @Override
    public Class<? extends OxmClassBase> getOxmClass() {
        return Nxm1Class.class;
    }
}

