/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.nx.codec.action;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.nx.api.NiciraActionDeserializerKey;
import org.opendaylight.openflowjava.nx.api.NiciraActionSerializerKey;
import org.opendaylight.openflowjava.nx.codec.action.AbstractActionCodec;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.ActionChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.ActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.action.container.action.choice.ActionSetNshc4;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.action.container.action.choice.ActionSetNshc4Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofj.nx.action.set.nshc._4.grouping.NxActionSetNshc4Builder;

public class SetNshc4Codec
extends AbstractActionCodec {
    public static final int LENGTH = 16;
    public static final byte NXAST_SET_NSC_SUBTYPE = 37;
    public static final NiciraActionSerializerKey SERIALIZER_KEY = new NiciraActionSerializerKey(4, ActionSetNshc4.class);
    public static final NiciraActionDeserializerKey DESERIALIZER_KEY = new NiciraActionDeserializerKey(4, 37);
    private static final int padding = 2;

    public void serialize(Action input, ByteBuf outBuffer) {
        ActionSetNshc4 action = (ActionSetNshc4)input.getActionChoice();
        SetNshc4Codec.serializeHeader(16, 37, outBuffer);
        outBuffer.writeZero(2);
        outBuffer.writeInt(action.getNxActionSetNshc4().getNshc().intValue());
    }

    public Action deserialize(ByteBuf message) {
        ActionBuilder actionBuilder = SetNshc4Codec.deserializeHeader(message);
        ActionSetNshc4Builder builder = new ActionSetNshc4Builder();
        NxActionSetNshc4Builder nxActionSetNspBuilder = new NxActionSetNshc4Builder();
        message.skipBytes(2);
        nxActionSetNspBuilder.setNshc(message.readUnsignedInt());
        builder.setNxActionSetNshc4(nxActionSetNspBuilder.build());
        actionBuilder.setActionChoice((ActionChoice)builder.build());
        return actionBuilder.build();
    }
}

