/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.nx.codec.action;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.nx.api.NiciraActionDeserializerKey;
import org.opendaylight.openflowjava.nx.api.NiciraActionSerializerKey;
import org.opendaylight.openflowjava.nx.codec.action.AbstractActionCodec;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.ActionChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.ActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.action.container.action.choice.ActionSetNshc3;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.action.container.action.choice.ActionSetNshc3Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofj.nx.action.set.nshc._3.grouping.NxActionSetNshc3Builder;

public class SetNshc3Codec
extends AbstractActionCodec {
    public static final int LENGTH = 16;
    public static final byte NXAST_SET_NSC_SUBTYPE = 36;
    public static final NiciraActionSerializerKey SERIALIZER_KEY = new NiciraActionSerializerKey(4, ActionSetNshc3.class);
    public static final NiciraActionDeserializerKey DESERIALIZER_KEY = new NiciraActionDeserializerKey(4, 36);
    private static final int padding = 2;

    public void serialize(Action input, ByteBuf outBuffer) {
        ActionSetNshc3 action = (ActionSetNshc3)input.getActionChoice();
        SetNshc3Codec.serializeHeader(16, 36, outBuffer);
        outBuffer.writeZero(2);
        outBuffer.writeInt(action.getNxActionSetNshc3().getNshc().intValue());
    }

    public Action deserialize(ByteBuf message) {
        ActionBuilder actionBuilder = SetNshc3Codec.deserializeHeader(message);
        ActionSetNshc3Builder builder = new ActionSetNshc3Builder();
        NxActionSetNshc3Builder nxActionSetNspBuilder = new NxActionSetNshc3Builder();
        message.skipBytes(2);
        nxActionSetNspBuilder.setNshc(message.readUnsignedInt());
        builder.setNxActionSetNshc3(nxActionSetNspBuilder.build());
        actionBuilder.setActionChoice((ActionChoice)builder.build());
        return actionBuilder.build();
    }
}

