/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.nx.codec.action;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.nx.api.NiciraActionDeserializerKey;
import org.opendaylight.openflowjava.nx.api.NiciraActionSerializerKey;
import org.opendaylight.openflowjava.nx.codec.action.AbstractActionCodec;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.ActionChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.ActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.action.container.action.choice.ActionSetNshc2;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.action.container.action.choice.ActionSetNshc2Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofj.nx.action.set.nshc._2.grouping.NxActionSetNshc2Builder;

public class SetNshc2Codec
extends AbstractActionCodec {
    public static final int LENGTH = 16;
    public static final byte NXAST_SET_NSC_SUBTYPE = 35;
    public static final NiciraActionSerializerKey SERIALIZER_KEY = new NiciraActionSerializerKey(4, ActionSetNshc2.class);
    public static final NiciraActionDeserializerKey DESERIALIZER_KEY = new NiciraActionDeserializerKey(4, 35);
    private static final int padding = 2;

    public void serialize(Action input, ByteBuf outBuffer) {
        ActionSetNshc2 action = (ActionSetNshc2)input.getActionChoice();
        SetNshc2Codec.serializeHeader(16, 35, outBuffer);
        outBuffer.writeZero(2);
        outBuffer.writeInt(action.getNxActionSetNshc2().getNshc().intValue());
    }

    public Action deserialize(ByteBuf message) {
        ActionBuilder actionBuilder = SetNshc2Codec.deserializeHeader(message);
        ActionSetNshc2Builder builder = new ActionSetNshc2Builder();
        NxActionSetNshc2Builder nxActionSetNspBuilder = new NxActionSetNshc2Builder();
        message.skipBytes(2);
        nxActionSetNspBuilder.setNshc(message.readUnsignedInt());
        builder.setNxActionSetNshc2(nxActionSetNspBuilder.build());
        actionBuilder.setActionChoice((ActionChoice)builder.build());
        return actionBuilder.build();
    }
}

