/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.nx.codec.action;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.nx.api.NiciraActionDeserializerKey;
import org.opendaylight.openflowjava.nx.api.NiciraActionSerializerKey;
import org.opendaylight.openflowjava.nx.codec.action.AbstractActionCodec;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.ActionChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.ActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.action.container.action.choice.ActionRegMove;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.action.container.action.choice.ActionRegMoveBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofj.nx.action.reg.move.grouping.NxActionRegMoveBuilder;

public class RegMoveCodec
extends AbstractActionCodec {
    public static final int LENGTH = 24;
    public static final byte SUBTYPE = 6;
    public static final NiciraActionSerializerKey SERIALIZER_KEY = new NiciraActionSerializerKey(4, ActionRegMove.class);
    public static final NiciraActionDeserializerKey DESERIALIZER_KEY = new NiciraActionDeserializerKey(4, 6);

    public void serialize(Action input, ByteBuf outBuffer) {
        ActionRegMove actionRegMove = (ActionRegMove)input.getActionChoice();
        RegMoveCodec.serializeHeader(24, 6, outBuffer);
        outBuffer.writeShort(actionRegMove.getNxActionRegMove().getNBits().intValue());
        outBuffer.writeShort(actionRegMove.getNxActionRegMove().getSrcOfs().intValue());
        outBuffer.writeShort(actionRegMove.getNxActionRegMove().getDstOfs().intValue());
        outBuffer.writeInt(actionRegMove.getNxActionRegMove().getSrc().intValue());
        outBuffer.writeInt(actionRegMove.getNxActionRegMove().getDst().intValue());
    }

    public Action deserialize(ByteBuf message) {
        ActionBuilder actionBuilder = RegMoveCodec.deserializeHeader(message);
        ActionRegMoveBuilder actionRegMoveBuilder = new ActionRegMoveBuilder();
        NxActionRegMoveBuilder nxActionRegMoveBuilder = new NxActionRegMoveBuilder();
        nxActionRegMoveBuilder.setNBits(message.readUnsignedShort());
        nxActionRegMoveBuilder.setSrcOfs(message.readUnsignedShort());
        nxActionRegMoveBuilder.setDstOfs(message.readUnsignedShort());
        nxActionRegMoveBuilder.setSrc(message.readUnsignedInt());
        nxActionRegMoveBuilder.setDst(message.readUnsignedInt());
        actionRegMoveBuilder.setNxActionRegMove(nxActionRegMoveBuilder.build());
        actionBuilder.setActionChoice((ActionChoice)actionRegMoveBuilder.build());
        return actionBuilder.build();
    }
}

